﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/ldn/detail/Debug/ldn_Log.h>
#include <nn/ldn/detail/Service/ldn_Service.sfdl.h>
#include <nn/ldn/detail/Service/ldn_ServiceCreator.h>
#include <nn/sf/sf_ObjectFactory.h>

namespace nn { namespace ldn { namespace detail { namespace
{
    nn::sf::UnmanagedServiceObject<
        IUserServiceCreator, UserServiceCreator> g_UserServiceCreator;

    nn::sf::UnmanagedServiceObject<
        IMonitorServiceCreator, MonitorServiceCreator> g_MonitorServiceCreator;

    nn::sf::UnmanagedServiceObject<
        ISystemServiceCreator, SystemServiceCreator> g_SystemServiceCreator;

}}}} // namespace nn::ldn::detail::<unnamed>

namespace nn { namespace ldn { namespace detail
{
    nn::sf::SharedPointer<IUserServiceCreator> CreateUserServiceCreatorByDfc() NN_NOEXCEPT
    {
        auto pService = g_UserServiceCreator.GetShared();
        return pService;
    }

    nn::sf::SharedPointer<IMonitorServiceCreator> CreateMonitorServiceCreatorByDfc() NN_NOEXCEPT
    {
        auto pService = g_MonitorServiceCreator.GetShared();
        return pService;
    }

    nn::sf::SharedPointer<ISystemServiceCreator> CreateSystemServiceCreatorByDfc() NN_NOEXCEPT
    {
        auto pService = g_SystemServiceCreator.GetShared();
        return pService;
    }

}}} // namespace nn::ldn::detail
