﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/os.h>
#include <nn/lcs/lcs_Types.h>
#include <nn/lcs/detail/lcs_State.h>

namespace nn { namespace lcs { namespace detail
{

    StateMachine::StateMachine() NN_NOEXCEPT :
        m_State(State_None),
        m_IsInitialized(false)
    {
    }

    void StateMachine::Initialize() NN_NOEXCEPT
    {
        m_State = State_Initialized;
        m_IsInitialized = true;
    }

    void StateMachine::Finalize() NN_NOEXCEPT
    {
        m_State = State_None;
        m_IsInitialized = false;
    }

    State StateMachine::GetState() NN_NOEXCEPT
    {
        return m_State;
    }

    bool StateMachine::SetState(State state) NN_NOEXCEPT
    {
        if (!m_IsInitialized)
        {
            return false;
        }
        m_State = state;
        return true;
    }

}}} // namespace nn::lcs
