﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Abort.h>
#include <nn/nn_Common.h>
#include <nn/kpr/kpr_KeyCodeComposer.h>
#include <nn/util/util_TypedStorage.h>

#include "detail/kpr_KeyCodeComposerImpl.h"

namespace nn { namespace kpr {

KeyCodeComposer::KeyCodeComposer() NN_NOEXCEPT
{
    InitializeKeyCodeComposer(&::nn::util::Get(m_Storage));
}

KeyCodeComposerMode KeyCodeComposer::GetMode() const NN_NOEXCEPT
{
    return GetKeyCodeComposerMode(::nn::util::Get(m_Storage));
}

void KeyCodeComposer::SetMode(KeyCodeComposerMode mode) NN_NOEXCEPT
{
    switch (mode)
    {
    case KeyCodeComposerMode_Default:
    case KeyCodeComposerMode_DeadKey:
    case KeyCodeComposerMode_RomajiHiragana:
    case KeyCodeComposerMode_RomajiKatakana:
        SetKeyCodeComposerMode(&::nn::util::Get(m_Storage), mode);
        break;

    default: NN_UNEXPECTED_DEFAULT;
    }
}

int KeyCodeComposer::GetCompositionCount() const NN_NOEXCEPT
{
    return GetKeyCodeComposerCompositionCount(::nn::util::Get(m_Storage));
}

int KeyCodeComposer::GetComposition(
    uint16_t outBuffer[], int count) const NN_NOEXCEPT
{
    NN_ABORT_UNLESS_NOT_NULL(outBuffer);
    NN_ABORT_UNLESS_GREATER_EQUAL(count, 0);

    return GetKeyCodeComposerComposition(
        ::nn::util::Get(m_Storage), outBuffer, count);
}

int KeyCodeComposer::Enqueue(const uint16_t buffer[], int count) NN_NOEXCEPT
{
    NN_ABORT_UNLESS_NOT_NULL(buffer);
    NN_ABORT_UNLESS_GREATER_EQUAL(count, 0);

    return EnqueueKeyCodeComposer(&::nn::util::Get(m_Storage), buffer, count);
}

int KeyCodeComposer::GetDequeueableCount() const NN_NOEXCEPT
{
    return GetKeyCodeComposerDequeueableCount(::nn::util::Get(m_Storage));
}

int KeyCodeComposer::Dequeue(uint16_t outBuffer[], int count) NN_NOEXCEPT
{
    NN_ABORT_UNLESS_NOT_NULL(outBuffer);
    NN_ABORT_UNLESS_GREATER_EQUAL(count, 0);

    return DequeueKeyCodeComposer(
        &::nn::util::Get(m_Storage), outBuffer, count);
}

int KeyCodeComposer::Remove(uint16_t outBuffer[], int count) NN_NOEXCEPT
{
    NN_ABORT_UNLESS_NOT_NULL(outBuffer);
    NN_ABORT_UNLESS_GREATER_EQUAL(count, 0);

    return RemoveKeyCodeComposer(
        &::nn::util::Get(m_Storage), outBuffer, count);
}

void KeyCodeComposer::Flush() NN_NOEXCEPT
{
    FlushKeyCodeComposer(&::nn::util::Get(m_Storage));
}

void KeyCodeComposer::Clear() NN_NOEXCEPT
{
    ClearKeyCodeComposer(&::nn::util::Get(m_Storage));
}

}} // namespace nn::kpr
