﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Abort.h>
#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/hid/hid_Keyboard.h>
#include <nn/kpr/kpr_KeyCode.h>
#include <nn/util/util_TypedStorage.h>

#include "detail/kpr_KeyCodeImpl.h"

namespace nn { namespace settings { namespace detail {

::nn::Result GetKeyCodeMap(::nn::kpr::KeyCodeMap* pOutValue) NN_NOEXCEPT;

}}} // namespace nn::settings::detail

namespace nn { namespace kpr {

namespace {

//!< キー入力の文字コード変換表の変換モードを内部表現に変換します。
detail::KeyCodeMapInternalMode ConvertKeyCodeMapMode(
    KeyCodeMapMode mode) NN_NOEXCEPT;

} // namespace

void GetKeyCodeMap(KeyCodeMap* pOutValue) NN_NOEXCEPT
{
    NN_ABORT_UNLESS_RESULT_SUCCESS(
        ::nn::settings::detail::GetKeyCodeMap(pOutValue));
}

bool IsKeyCodeMapModeSupported(
    const KeyCodeMap& map, KeyCodeMapMode mode) NN_NOEXCEPT
{
    return detail::IsKeyCodeMapModeSupported(
        ::nn::util::Get(map._storage), ConvertKeyCodeMapMode(mode));
}

void GetKeyCode(
    KeyCode* pOutValue,
    int usageId, ::nn::hid::KeyboardModifierSet modifiers,
    const KeyCodeMap& map, KeyCodeMapMode mode) NN_NOEXCEPT
{
    NN_ABORT_UNLESS_NOT_NULL(pOutValue);
    NN_ABORT_UNLESS_MINMAX(usageId, 0x0000, 0xFFFF);
    detail::GetKeyCode(
        pOutValue, usageId, modifiers, ::nn::util::Get(map._storage),
        ConvertKeyCodeMapMode(mode));
}

namespace {

detail::KeyCodeMapInternalMode ConvertKeyCodeMapMode(
    KeyCodeMapMode mode) NN_NOEXCEPT
{
    switch (mode)
    {
    case KeyCodeMapMode_Default:
        return detail::KeyCodeMapInternalMode::Default;
    case KeyCodeMapMode_Hiragana:
        return detail::KeyCodeMapInternalMode::Hiragana;
    case KeyCodeMapMode_Katakana:
        return detail::KeyCodeMapInternalMode::Katakana;
    case KeyCodeMapMode_Cyrillic:
        return detail::KeyCodeMapInternalMode::Cyrillic;
    case KeyCodeMapMode_Hangul:
        return detail::KeyCodeMapInternalMode::Hangul;
    case KeyCodeMapMode_Zhuyin:
        return detail::KeyCodeMapInternalMode::Zhuyin;
    case KeyCodeMapMode_Cangjie:
        return detail::KeyCodeMapInternalMode::Cangjie;
    default: NN_UNEXPECTED_DEFAULT;
    }
}

} // namespace

}} // namespace nn::kpr
