﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Nintendo;
using Nintendo.ServiceFramework;
using Nintendo.ServiceFramework.CppCode;
using Nintendo.ServiceFramework.Hipc;
using Nintendo.ServiceFramework.Applet;
using nn;
using nn.sf;
using std;

namespace nn.applet
{
    [CppRefPath(@"<nn/applet/applet_FundamentalTypes.h>")]
    [ExternalStruct(8, 8)]
    public struct AppletResourceUserId
    {
    }

    [CppRefPath(@"<nn/applet/applet_FundamentalTypes.h>")]
    [CheckAppletResourceUserId]
    [CppFullName("nn::applet::AppletResourceUserId")]
    [ExternalStruct(8, 8)]
    public struct CheckedAppletResourceUserId
    {
    }
}

namespace nn.hid
{
    [CppRefPath(@"<nn/hid/hid_Npad.h>")]
    [ExternalStruct(4, 4)]
    public struct NpadIdType
    {
    }
}

namespace nn.irsensor
{
    [CppRefPath(@"<nn/irsensor/irsensor_IrCameraTypes.h>")]
    [ExternalStruct(4, 4)]
    public struct IrCameraHandle
    {
    }

    [CppRefPath(@"<nn/irsensor/irsensor_ImageTransferProcessorTypes.h>")]
    [ExternalStruct(16, 8)]
    public struct ImageTransferProcessorState
    {
    }

    [CppRefPath(@"<nn/irsensor/irsensor_PackedTypes.h>")]
    [ExternalStruct(32, 8)]
    public struct PackedMomentProcessorConfig
    {
    }

    [CppRefPath(@"<nn/irsensor/irsensor_PackedTypes.h>")]
    [ExternalStruct(40, 8)]
    public struct PackedClusteringProcessorConfig
    {
    }

    [CppRefPath(@"<nn/irsensor/irsensor_PackedTypes.h>")]
    [ExternalStruct(24, 8)]
    public struct PackedImageTransferProcessorConfig
    {
    }

    [CppRefPath(@"<nn/irsensor/irsensor_PackedTypes.h>")]
    [ExternalStruct(32, 8)]
    public struct PackedImageTransferProcessorExConfig
    {
    }

    [CppRefPath(@"<nn/irsensor/irsensor_PackedTypes.h>")]
    [ExternalStruct(8, 4)]
    public struct PackedTeraPluginProcessorConfig
    {
    }

    [CppRefPath(@"<nn/irsensor/irsensor_PackedTypes.h>")]
    [ExternalStruct(12, 4)]
    public struct PackedPointingProcessorConfig
    {
    }

    [CppRefPath(@"<nn/irsensor/irsensor_PackedTypes.h>")]
    [ExternalStruct(4, 4)]
    public struct PackedMcuVersion
    {
    }

    [CppRefPath(@"<nn/irsensor/irsensor_PackedTypes.h>")]
    [ExternalStruct(4, 4)]
    public struct PackedFunctionLevel
    {
    }

    [CppRefPath(@"<nn/irsensor/irsensor_PackedTypes.h>")]
    [ExternalStruct(8, 4)]
    public struct PackedIrLedProcessorConfig
    {
    }

    [CppRefPath(@"<nn/irsensor/irsensor_IIrSensorServer.h>")]
    public interface IIrSensorServer : IServiceObject
    {
        //[MethodId(300)] Xpad 対応時の遺産
        //[MethodId(301)] JoyXpad 対応時の遺産

        [MethodId(302)]
        Result ActivateIrsensor(
            nn.applet.CheckedAppletResourceUserId aruid);

        [MethodId(303)]
        Result DeactivateIrsensor(
            nn.applet.CheckedAppletResourceUserId aruid);

        [MethodId(304)]
        Result GetIrsensorSharedMemoryHandle(
            Out<NativeHandle> outValue,
            nn.applet.CheckedAppletResourceUserId aruid);

        [MethodId(305)]
        Result StopImageProcessor(
            nn.applet.CheckedAppletResourceUserId aruid,
            nn.irsensor.IrCameraHandle handle);

        [MethodId(306)]
        Result RunMomentProcessor(
            nn.applet.CheckedAppletResourceUserId aruid,
            nn.irsensor.IrCameraHandle handle,
            nn.irsensor.PackedMomentProcessorConfig config);

        [MethodId(307)]
        Result RunClusteringProcessor(
            nn.applet.CheckedAppletResourceUserId aruid,
            nn.irsensor.IrCameraHandle handle,
            nn.irsensor.PackedClusteringProcessorConfig config);

        [MethodId(308)]
        Result RunImageTransferProcessor(
            nn.applet.CheckedAppletResourceUserId aruid,
            nn.irsensor.IrCameraHandle handle,
            nn.irsensor.PackedImageTransferProcessorConfig config,
            NativeHandle transferMemoryHandle,
            uint64_t size);

        [MethodId(309)]
        Result GetImageTransferProcessorState(
            nn.applet.CheckedAppletResourceUserId aruid,
            Out<nn.irsensor.ImageTransferProcessorState> outState,
            OutBuffer outBuffer,
            nn.irsensor.IrCameraHandle handle);

        [MethodId(310)]
        Result RunTeraPluginProcessor(
            nn.applet.CheckedAppletResourceUserId aruid,
            nn.irsensor.IrCameraHandle handle,
            nn.irsensor.PackedTeraPluginProcessorConfig config);

        [MethodId(311)]
        Result GetNpadIrCameraHandle(
            Out<nn.irsensor.IrCameraHandle> outValue,
            nn.hid.NpadIdType npadIdType);

        [MethodId(312)]
        Result RunPointingProcessor(
            nn.applet.CheckedAppletResourceUserId aruid,
            nn.irsensor.IrCameraHandle handle,
            nn.irsensor.PackedPointingProcessorConfig config);

        [MethodId(313)]
        Result SuspendImageProcessor(
            nn.applet.CheckedAppletResourceUserId aruid,
            nn.irsensor.IrCameraHandle handle);

        [MethodId(314)]
        Result CheckFirmwareVersion(
            nn.applet.CheckedAppletResourceUserId aruid,
            nn.irsensor.IrCameraHandle handle,
            nn.irsensor.PackedMcuVersion requiredVersion);

        [MethodId(315)]
        Result SetFunctionLevel(
            nn.applet.CheckedAppletResourceUserId aruid,
            nn.irsensor.IrCameraHandle handle,
            nn.irsensor.PackedFunctionLevel functionLevel);

        [MethodId(316)]
        Result RunImageTransferExProcessor(
            nn.applet.CheckedAppletResourceUserId aruid,
            nn.irsensor.IrCameraHandle handle,
            nn.irsensor.PackedImageTransferProcessorExConfig config,
            NativeHandle transferMemoryHandle,
            uint64_t size);

        [MethodId(317)]
        Result RunIrLedProcessor(
            nn.applet.CheckedAppletResourceUserId aruid,
            nn.irsensor.IrCameraHandle handle,
            nn.irsensor.PackedIrLedProcessorConfig config);

        [MethodId(318)]
        Result StopImageProcessorAsync(
            nn.applet.CheckedAppletResourceUserId aruid,
            nn.irsensor.IrCameraHandle handle);

        [MethodId(319)]
        Result ActivateIrsensorWithFunctionLevel(
            nn.applet.CheckedAppletResourceUserId aruid,
            nn.irsensor.PackedFunctionLevel functionLevel);
    }
}
