﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <atomic>
#include <mutex>
#include <nn/nn_Macro.h>
#include <nn/nn_Result.h>
#include <nn/irsensor/irsensor_ServiceName.h>
#include <nn/irsensor/irsensor_IIrSensorServer.h>
#include <nn/lmem/lmem_Common.h>
#include <nn/os/os_Mutex.h>
#include <nn/result/result_HandlingUtility.h>
#include <nn/sf/sf_ExpHeapAllocator.h>
#include <nn/sf/sf_HipcClientProxyByName.h>
#include <nn/sf/sf_ISharedObject.h>

#include "irsensor_IrSensorServer.h"
#include "irsensor_LockableMutexType.h"

namespace nn { namespace irsensor { namespace detail {

namespace {

//!< IPC 用ヒープメモリを扱うクラスです。
typedef ::nn::sf::ExpHeapStaticAllocator<16 * 1024, IrSensorServer> Allocator;

}

::nn::Result CreateIrSensorServerProxy(
    ::nn::sf::SharedPointer<IIrSensorServer>* outValue) NN_NOEXCEPT
{
    static ::std::atomic<bool> s_IsInitialized(false);

    static LockableMutexType s_Mutex = { NN_OS_MUTEX_INITIALIZER(false) };

    if (!s_IsInitialized)
    {
        ::std::lock_guard<decltype(s_Mutex)> locker(s_Mutex);

        if (!s_IsInitialized)
        {
            Allocator::Initialize(::nn::lmem::CreationOption_NoOption);

            s_IsInitialized = true;
        }
    }

    NN_RESULT_THROW((::nn::sf::CreateHipcProxyByName<
         IIrSensorServer, Allocator::Policy>)(outValue, IrSensorServiceName));
}

}}} // namespace nn::irsensor::detail
