﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Macro.h>
#include <nn/nn_Result.h>
#include <nn/os/os_Mutex.h>
#include <nn/hid/system/hid_Irsensor.h>
#include <nn/irsensor/irsensor_IrCameraTypesPrivate.h>

#include "irsensor_IrCameraHandle.h"

namespace nn { namespace irsensor { namespace detail {

//!< IR センサーの内部エラーを扱うためのクラスです。
class InternalErrorHandler final
{
    NN_DISALLOW_COPY(InternalErrorHandler);
    NN_DISALLOW_MOVE(InternalErrorHandler);

private:
    //!< 排他用のミューテックス
    ::nn::os::Mutex m_Mutex;

    //!< 各ハンドルごとの内部状態
    IrCameraInternalStatus m_InternalStatus[::nn::hid::system::IrSensorSupportedNpadIdsCount];

public:
    InternalErrorHandler() NN_NOEXCEPT;

    ~InternalErrorHandler() NN_NOEXCEPT;

    //!< 内部で状態管理を行い、LA 呼び出しが必要かどうかを返します。
    bool IsLibraryAppletCallEnabled(
        const IrCameraInternalStatus& status,
        const IrCameraHandle& handle) NN_NOEXCEPT;

    //!< 内部状態をリセットします
    void SetInternalStatus(
        const IrCameraInternalStatus& status,
        const IrCameraHandle& handle) NN_NOEXCEPT;
};

}}} // namespace nn::irsensor::detail
