﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Macro.h>
#include <nn/nn_Result.h>
#include <nn/irsensor/irsensor_ClusteringProcessorTypes.h>
#include <nn/irsensor/irsensor_ImageTransferProcessorTypes.h>
#include <nn/irsensor/irsensor_IrCameraTypes.h>
#include <nn/irsensor/irsensor_IrCameraTypesPrivate.h>
#include <nn/irsensor/irsensor_MomentProcessorTypes.h>
#include <nn/irsensor/irsensor_PointingProcessorTypesPrivate.h>
#include <nn/irsensor/irsensor_TeraPluginProcessorApiPrivate.h>
#include <nn/irsensor/irsensor_TeraPluginProcessorTypesPrivate.h>
#include <nn/irsensor/irsensor_IrLedProcessorTypes.h>
#include <nn/hid/hid_Npad.h>

namespace nn { namespace irsensor { namespace detail {

::nn::Result GetIrCameraHandle(
    IrCameraHandle* pOutValue,
    const ::nn::hid::NpadIdType& npadIdType) NN_NOEXCEPT;

::nn::Result InitializeIrCamera(
    const IrSensorFunctionLevel& functionLevel,
    const IrCameraHandle& handle) NN_NOEXCEPT;

::nn::Result FinalizeIrCamera(
    const IrCameraHandle& handle) NN_NOEXCEPT;

::nn::Result GetIrCameraStatus(
    IrCameraStatus* pOutValue,
    const IrCameraHandle& handle) NN_NOEXCEPT;

::nn::Result GetIrCameraInternalStatus(
    IrCameraInternalStatus* pOutValue,
    const IrCameraHandle& handle) NN_NOEXCEPT;

::nn::Result GetImageProcessorStatus(
    ImageProcessorStatus* pOutValue,
    const bool& isInternalCall,
    const IrCameraHandle& handle) NN_NOEXCEPT;

::nn::Result CheckFirmwareUpdateNecessity(
    bool* pOutIsUpdateNeeded,
    const IrCameraHandle& handle) NN_NOEXCEPT;

::nn::Result CheckStatus(
    const nn::Result defaultResult,
    const IrCameraHandle& handle) NN_NOEXCEPT;

::nn::Result CheckInternalStatus(
    const IrCameraHandle& handle) NN_NOEXCEPT;

::nn::Result CheckLibraryAppletAvailability(
    bool* pOutIsLibraryAppletCallEnabled,
    const IrCameraInternalStatus& status,
    const IrCameraHandle& handle) NN_NOEXCEPT;

::nn::Result StopImageProcessor(
    const IrCameraHandle& handle) NN_NOEXCEPT;

::nn::Result StopImageProcessorAsync(
    const IrCameraHandle& handle) NN_NOEXCEPT;

::nn::Result RunMomentProcessor(
    const IrCameraHandle& handle,
    const MomentProcessorConfig& config) NN_NOEXCEPT;

::nn::Result GetMomentProcessorState(
    MomentProcessorState* pOutValue,
    const IrCameraHandle& handle) NN_NOEXCEPT;

::nn::Result GetMomentProcessorStates(
    MomentProcessorState* pOutStates,
    int* pOutCount, int countMax,
    const IrCameraHandle& handle) NN_NOEXCEPT;

::nn::Result RunClusteringProcessor(
    const IrCameraHandle& handle,
    const ClusteringProcessorConfig& config) NN_NOEXCEPT;

::nn::Result GetClusteringProcessorState(
    ClusteringProcessorState* pOutValue,
    const IrCameraHandle& handle) NN_NOEXCEPT;

::nn::Result GetClusteringProcessorStates(
    ClusteringProcessorState* pOutStates,
    int* pOutCount, int countMax,
    const IrCameraHandle& handle) NN_NOEXCEPT;

::nn::Result RunImageTransferProcessor(
    const IrCameraHandle& handle,
    const ImageTransferProcessorConfig& config,
    void* workBuffer,
    size_t size) NN_NOEXCEPT;

::nn::Result RunImageTransferProcessor(
    const IrCameraHandle& handle,
    const ImageTransferProcessorExConfig& config,
    void* workBuffer,
    size_t size) NN_NOEXCEPT;

::nn::Result GetImageTransferProcessorState(
    ImageTransferProcessorState* pOutState,
    void* pOutImage,
    size_t size,
    const IrCameraHandle& handle) NN_NOEXCEPT;

::nn::Result RunPointingProcessor(
    const IrCameraHandle& handle) NN_NOEXCEPT;

::nn::Result GetPointingProcessorStates(
    PointingProcessorMarkerState* pOutStates,
    int* pOutCount, int countMax,
    const IrCameraHandle& handle) NN_NOEXCEPT;

::nn::Result RunTeraPluginProcessor(
    const IrCameraHandle& handle,
    const TeraPluginProcessorConfig& config) NN_NOEXCEPT;

::nn::Result GetTeraPluginProcessorStates(
    TeraPluginProcessorState* pOutStates,
    int* pOutCount, int countMax, int64_t infSamplingNumber,
    uint32_t prefix,
    int prefixSize,
    const IrCameraHandle& handle) NN_NOEXCEPT;

::nn::Result RunIrLedProcessor(
    const IrCameraHandle& handle,
    const IrLedProcessorConfig& config) NN_NOEXCEPT;

::nn::Result GetIrLedProcessorState(
    const IrCameraHandle& handle) NN_NOEXCEPT;

}}} // namespace nn::irsensor::detail
