﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Abort.h>
#include <nn/nn_Common.h>
#include <nn/nn_Macro.h>
#include <nn/nn_Result.h>
#include <nn/nn_SdkAssert.h>
#include <nn/nn_TimeSpan.h>
#include <nn/os/os_MemoryHeapCommon.h>

#include <nn/hidbus/hidbus.h>

#include "detail/hidbus_ApiImpl.h"

namespace nn { namespace hidbus {

bool GetBusHandle(nn::hidbus::BusHandle* pOutHandle, const nn::hid::NpadIdType &id, BusType busType) NN_NOEXCEPT
{
    return detail::GetBusHandle(pOutHandle, id, busType);
}

nn::Result Initialize(const nn::hidbus::BusHandle& handle) NN_NOEXCEPT
{
    return detail::Initialize(handle);
}

void Finalize(const nn::hidbus::BusHandle& handle) NN_NOEXCEPT
{
    detail::Finalize(handle);
}

nn::Result EnableExternalDevice(bool isEnabled, uint32_t deviceId, const nn::hidbus::BusHandle& handle) NN_NOEXCEPT
{
    return detail::EnableExternalDevice(isEnabled, deviceId, handle);
}

nn::Result SendAndReceive(size_t* pOutSize,
                          void* pOutBuffer, size_t outBufferSize,
                          const nn::hidbus::BusHandle& handle,
                          const void* pInBuffer, size_t inBufferSize) NN_NOEXCEPT
{
    return detail::SendAndReceive(pOutSize, pOutBuffer, outBufferSize, handle, pInBuffer, inBufferSize);
}

nn::Result EnableJoyPollingReceiveMode(const nn::hidbus::BusHandle& handle,
    const void* pInCommand, size_t inCommandSize,
    void* workBuffer, size_t workBufferSize,
    JoyPollingMode mode) NN_NOEXCEPT
{
    return detail::EnableJoyPollingReceiveMode(handle, pInCommand, inCommandSize, workBuffer, workBufferSize, mode);
}

nn::Result DisableJoyPollingReceiveMode(const nn::hidbus::BusHandle& handle) NN_NOEXCEPT
{
    return detail::DisableJoyPollingReceiveMode(handle);
}

nn::Result GetJoyPollingReceivedData(JoyPollingReceivedData* pOutData, const nn::hidbus::BusHandle& handle) NN_NOEXCEPT
{
    return detail::GetJoyPollingReceivedData(pOutData, handle);
}

nn::Result GetJoyPollingReceivedData(JoyPollingReceivedData* pOutData, int count, const nn::hidbus::BusHandle& handle) NN_NOEXCEPT
{
    return detail::GetJoyPollingReceivedData(pOutData, count, handle);
}

}} // namespace nn::hidbus
