﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Abort.h>
#include <nn/nn_SdkAssert.h>
#include <nn/hid/hid_VibrationGcErm.h>
#include "detail/hid_VibrationDeviceApiImpl.h"

namespace nn { namespace hid {

void SendVibrationGcErmCommand(const VibrationDeviceHandle& handle, const VibrationGcErmCommand& command) NN_NOEXCEPT
{
    NN_ABORT_UNLESS_RESULT_SUCCESS(detail::SendVibrationGcErmCommand(handle, command));
}

void GetActualVibrationGcErmCommand(VibrationGcErmCommand* pOutValue, const VibrationDeviceHandle& handle) NN_NOEXCEPT
{
    NN_ABORT_UNLESS_NOT_NULL(pOutValue);
    NN_ABORT_UNLESS_RESULT_SUCCESS(detail::GetActualVibrationGcErmCommand(pOutValue, handle));
}

}} // namespace nn::hid
