﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Abort.h>
#include <nn/nn_SdkAssert.h>
#include <nn/hid/hid_VibrationDeviceApi.h>
#include <nn/hid/hid_VibrationPermissionApi.h>
#include "detail/hid_VibrationDeviceApiImpl.h"
#include "detail/hid_VibrationMasterVolumeImpl.h"

namespace nn { namespace hid {

void PermitVibration(bool isPermitted) NN_NOEXCEPT
{
    NN_ABORT_UNLESS_RESULT_SUCCESS(detail::PermitVibration(isPermitted));
}

bool IsVibrationPermitted() NN_NOEXCEPT
{
    bool isPermitted = false;
    NN_ABORT_UNLESS_RESULT_SUCCESS(detail::IsVibrationPermitted(&isPermitted));
    return isPermitted;
}

void BeginForcedVibrationSession() NN_NOEXCEPT
{
    NN_ABORT_UNLESS_RESULT_SUCCESS(detail::BeginPermitVibrationSession());
}

void EndForcedVibrationSession() NN_NOEXCEPT
{
    NN_ABORT_UNLESS_RESULT_SUCCESS(detail::EndPermitVibrationSession());
}

int GetVibrationDeviceHandles(VibrationDeviceHandle* pOutValues, int count, const NpadIdType& id, NpadStyleSet style) NN_NOEXCEPT
{
    int outCount;

    detail::GetVibrationDeviceHandles(pOutValues, &outCount, count, id, style);

    return outCount;
}

void InitializeVibrationDevice(const VibrationDeviceHandle& handle) NN_NOEXCEPT
{
    NN_ABORT_UNLESS_RESULT_SUCCESS(detail::InitializeVibrationDevice(handle));
}

void GetVibrationDeviceInfo(VibrationDeviceInfo* pOutValue, const VibrationDeviceHandle& handle) NN_NOEXCEPT
{
    NN_ABORT_UNLESS_NOT_NULL(pOutValue);
    NN_ABORT_UNLESS_RESULT_SUCCESS(detail::GetVibrationDeviceInfo(pOutValue, handle));
}

void SendVibrationValue(const VibrationDeviceHandle& handle, const VibrationValue& value) NN_NOEXCEPT
{
    NN_ABORT_UNLESS_RESULT_SUCCESS(detail::SendVibrationValue(handle, value));
}

void GetActualVibrationValue(VibrationValue* pOutValue, const VibrationDeviceHandle& handle) NN_NOEXCEPT
{
    NN_ABORT_UNLESS_NOT_NULL(pOutValue);
    NN_ABORT_UNLESS_RESULT_SUCCESS(detail::GetActualVibrationValue(pOutValue, handle));
}

}} // namespace nn::hid
