﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Abort.h>
#include <nn/nn_SdkAssert.h>
#include <nn/hid/system/hid_UsbFullKey.h>
#include <nn/hid/system/hid_Npad.h>
#include "detail/hid_UsbFullKeyImpl.h"
#include "detail/hid_UniquePadImpl.h"

namespace nn { namespace hid { namespace system {

void EnableUsbFullKeyController(bool enabled) NN_NOEXCEPT
{
    NN_ABORT_UNLESS_RESULT_SUCCESS(detail::EnableUsbFullKeyController(enabled));
}

bool IsUsbFullKeyControllerEnabled() NN_NOEXCEPT
{
    bool isEnabled = false;
    NN_ABORT_UNLESS_RESULT_SUCCESS(detail::IsUsbFullKeyControllerEnabled(&isEnabled));
    return isEnabled;
}

bool IsUsbConnected(UniquePadId id) NN_NOEXCEPT
{
    bool isConnected = false;
    NN_ABORT_UNLESS_RESULT_SUCCESS(detail::IsUsbConnected(&isConnected, id));
    return isConnected;
}

}}} // namespace nn::hid::system

namespace nn { namespace hid {

void EnableUsbFullKeyController(bool enabled) NN_NOEXCEPT
{
    NN_ABORT_UNLESS_RESULT_SUCCESS(detail::EnableUsbFullKeyControllerForApplication(enabled));
}

bool IsUsbFullKeyControllerEnabled() NN_NOEXCEPT
{
    bool isEnabled = false;
    NN_ABORT_UNLESS_RESULT_SUCCESS(detail::IsUsbFullKeyControllerEnabledForApplication(&isEnabled));
    return isEnabled;
}

bool IsUsbFullKeyControllerConnected(const NpadIdType& id) NN_NOEXCEPT
{
    bool isEnabled;

    NN_ABORT_UNLESS_RESULT_SUCCESS(detail::IsUsbFullKeyControllerConnectedForApplication(&isEnabled, id));

    return isEnabled;
}

}} // namespace nn::hid
