﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Abort.h>
#include <nn/nn_Macro.h>
#include <nn/hid/debug/hid_SleepButton.h>
#include <nn/hid/system/hid_SleepButton.h>
#include <nn/os/os_SystemEventTypes.h>

#include "detail/hid_SleepButtonImpl.h"

namespace nn { namespace hid { namespace system {

void BindSleepButtonEvent(::nn::os::SystemEventType* pEvent,
                          ::nn::os::EventClearMode clearMode) NN_NOEXCEPT
{
    NN_ABORT_UNLESS_RESULT_SUCCESS(
        ::nn::hid::detail::BindSleepButtonEvent(pEvent, clearMode));
}

void InitializeSleepButton() NN_NOEXCEPT
{
    NN_ABORT_UNLESS_RESULT_SUCCESS(
        ::nn::hid::detail::InitializeSleepButton());
}

int GetSleepButtonStates(SleepButtonState* outStates, int count) NN_NOEXCEPT
{
    auto gotCount = int();
    NN_ABORT_UNLESS_RESULT_SUCCESS(
        ::nn::hid::detail::GetSleepButtonStates(&gotCount, outStates, count));
    return gotCount;
}

}}} // namespace nn::hid::system

namespace nn { namespace hid { namespace debug {

void FinalizeSleepButton() NN_NOEXCEPT
{
    NN_ABORT_UNLESS_RESULT_SUCCESS(
        ::nn::hid::detail::FinalizeSleepButton());
}

void SetSleepButtonAutoPilotState(const SleepButtonAutoPilotState& value
                                  ) NN_NOEXCEPT
{
    NN_ABORT_UNLESS_RESULT_SUCCESS(
        ::nn::hid::detail::SetSleepButtonAutoPilotState(value));
}

void UnsetSleepButtonAutoPilotState() NN_NOEXCEPT
{
    NN_ABORT_UNLESS_RESULT_SUCCESS(
        ::nn::hid::detail::UnsetSleepButtonAutoPilotState());
}

}}} // namespace nn::hid::debug
