﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Abort.h>
#include <nn/nn_Macro.h>
#include <nn/nn_SdkAssert.h>
#include <nn/hid/hid_NpadControlPad.h>

#include "detail/hid_NpadImpl.h"

namespace nn { namespace hid {

void SetControlPadRestrictionType(NpadStyleSet style, ControlPadRestrictionType type) NN_NOEXCEPT
{
    NN_SDK_REQUIRES_GREATER_EQUAL(style.CountPopulation(), 1);

    NN_ABORT_UNLESS_RESULT_SUCCESS(
        detail::SetControlPadRestrictionType(style, type));
}

ControlPadRestrictionType GetControlPadRestrictionType(NpadStyleSet style) NN_NOEXCEPT
{
    NN_SDK_REQUIRES_EQUAL(style.CountPopulation(), 1);

    ControlPadRestrictionType outValue;

    NN_ABORT_UNLESS_RESULT_SUCCESS(
        detail::GetControlPadRestrictionType(style, &outValue));

    return outValue;
}

void EnableControlPadRestriction(const NpadStyleSet& style, bool enable) NN_NOEXCEPT
{
    NN_SDK_REQUIRES_GREATER_EQUAL(style.CountPopulation(), 1);

    NN_ABORT_UNLESS_RESULT_SUCCESS(
        detail::EnableControlPadRestriction(style, enable));
}

}} // namespace nn::hid

