﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Abort.h>
#include <nn/nn_Macro.h>
#include <nn/nn_SdkAssert.h>
#include <nn/hid/hid_DebugPad.h>
#include <nn/hid/debug/hid_DebugPad.h>

#include "detail/hid_DebugPadImpl.h"

namespace nn { namespace hid {

void InitializeDebugPad() NN_NOEXCEPT
{
    NN_ABORT_UNLESS_RESULT_SUCCESS(detail::InitializeDebugPad());
}

void GetDebugPadState(DebugPadState* pOutValue) NN_NOEXCEPT
{
    NN_ABORT_UNLESS_RESULT_SUCCESS(detail::GetDebugPadState(pOutValue));
}

int GetDebugPadStates(DebugPadState outValues[], int count) NN_NOEXCEPT
{
    auto value = int();
    NN_ABORT_UNLESS_RESULT_SUCCESS(
        detail::GetDebugPadStates(&value, outValues, count));
    return value;
}

}} // namespace nn::hid

namespace nn { namespace hid { namespace debug {

void FinalizeDebugPad() NN_NOEXCEPT
{
    NN_ABORT_UNLESS_RESULT_SUCCESS(::nn::hid::detail::FinalizeDebugPad());
}

void SetDebugPadAutoPilotState(const DebugPadAutoPilotState& value) NN_NOEXCEPT
{
    NN_ABORT_UNLESS_RESULT_SUCCESS(
        ::nn::hid::detail::SetDebugPadAutoPilotState(value));
}

void UnsetDebugPadAutoPilotState() NN_NOEXCEPT
{
    NN_ABORT_UNLESS_RESULT_SUCCESS(
        ::nn::hid::detail::UnsetDebugPadAutoPilotState());
}

}}} // namespace nn::hid::debug
