﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Abort.h>
#include <nn/nn_Macro.h>
#include <nn/applet/applet_FundamentalTypes.h>
#include <nn/hid/system/hid_Applet.h>

#include "detail/hid_AppletImpl.h"

namespace nn { namespace hid { namespace system {

void SetAppletResourceUserId(const ::nn::applet::AppletResourceUserId& value
                         ) NN_NOEXCEPT
{
    NN_ABORT_UNLESS_RESULT_SUCCESS(
        ::nn::hid::detail::SetAppletResourceUserId(value));
}

void RegisterAppletResourceUserId(
    const ::nn::applet::AppletResourceUserId& aruid,
    bool enablesInput) NN_NOEXCEPT
{
    NN_ABORT_UNLESS_RESULT_SUCCESS(
        ::nn::hid::detail::RegisterAppletResourceUserId(aruid, enablesInput));
}

void UnregisterAppletResourceUserId(
    const ::nn::applet::AppletResourceUserId& aruid) NN_NOEXCEPT
{
    NN_ABORT_UNLESS_RESULT_SUCCESS(
        ::nn::hid::detail::UnregisterAppletResourceUserId(aruid));
}

void EnableAppletToGetInput(const ::nn::applet::AppletResourceUserId& aruid,
                            bool enablesInput) NN_NOEXCEPT
{
    NN_ABORT_UNLESS_RESULT_SUCCESS(
        ::nn::hid::detail::EnableAppletToGetInput(aruid, enablesInput));
}

void SetAruidValidForVibration(
    const ::nn::applet::AppletResourceUserId& aruid, bool enable) NN_NOEXCEPT
{
    NN_ABORT_UNLESS_RESULT_SUCCESS(
        ::nn::hid::detail::SetAruidValidForVibration(aruid, enable));
}

void EnableAppletToGetSixAxisSensor(const ::nn::applet::AppletResourceUserId& aruid,
                                    bool enablesInput) NN_NOEXCEPT
{
    NN_ABORT_UNLESS_RESULT_SUCCESS(
        ::nn::hid::detail::EnableAppletToGetSixAxisSensor(aruid, enablesInput));
}
}}} // namespace nn::hid::system
