﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/


#include <nn/nn_Abort.h>
#include <nn/nn_Macro.h>
#include <nn/os/os_SystemEvent.h>

#include <nn/hid/debug/hid_AbstractedPad.h>
#include "detail/hid_AbstractedPadImpl.h"

namespace nn { namespace hid { namespace debug {

::nn::Result SetAutoPilotVirtualPadState(const ::nn::hid::debug::AbstractedVirtualPadId& virtualPadId,
                                 const ::nn::hid::debug::AbstractedPadState& value) NN_NOEXCEPT
{
    return detail::SetAutoPilotVirtualPadState(virtualPadId, value);
}

::nn::Result UnsetAutoPilotVirtualPadState(const ::nn::hid::debug::AbstractedVirtualPadId& virtualPadId) NN_NOEXCEPT
{
    return detail::UnsetAutoPilotVirtualPadState(virtualPadId);
}

::nn::Result UnsetAllAutoPilotVirtualPadState() NN_NOEXCEPT
{
    return detail::UnsetAllAutoPilotVirtualPadState();
}

::nn::Result GetAbstractedPadHandles(int* pOutCount, debug::AbstractedPadHandle* pOutHandles, int count) NN_NOEXCEPT
{
    return detail::GetAbstractedPadHandles(pOutCount, pOutHandles, count);
}

::nn::Result GetAbstractedPadState(debug::AbstractedPadState* pOutState, ::nn::hid::debug::AbstractedPadHandle handle) NN_NOEXCEPT
{
    return detail::GetAbstractedPadState(pOutState, handle);
}

::nn::Result GetAbstractedPadsState(int* pOutCount, debug::AbstractedPadHandle* pOutHandles, debug::AbstractedPadState* pOutStates, int count) NN_NOEXCEPT
{
    return detail::GetAbstractedPadsState(pOutCount, pOutHandles, pOutStates, count);
}

}}} // namespace nn::hid::debug
