﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Macro.h>
#include <nn/nn_Result.h>
#include <nn/result/result_HandlingUtility.h>
#include <nn/settings/settings_Xpad.h>

#include "hid_ResourceManager-os.win.h"
#include "hid_XpadMapImpl.h"

namespace nn { namespace hid { namespace detail {

::nn::Result GetXpadGenericPadMap(
    ::nn::settings::BasicXpadGenericPadMap* outValue,
    int playerNumber) NN_NOEXCEPT
{
    NN_RESULT_DO(
        GetResourceManager().AssertValidBasicXpadPlayerNumber(playerNumber));
    NN_RESULT_DO(
        GetResourceManager().GetXpadMappingManager(playerNumber)
                            .GetBasicXpadGenericPadMap(outValue));
    NN_RESULT_SUCCESS;
}

::nn::Result SetXpadGenericPadMap(
    const ::nn::settings::BasicXpadGenericPadMap& value,
    int playerNumber) NN_NOEXCEPT
{
    NN_RESULT_DO(
        GetResourceManager().AssertValidBasicXpadPlayerNumber(playerNumber));
    NN_RESULT_DO(
        GetResourceManager().GetXpadMappingManager(playerNumber)
                            .SetBasicXpadGenericPadMap(value));
    NN_RESULT_SUCCESS;
}

::nn::Result ResetXpadGenericPadMap(int playerNumber) NN_NOEXCEPT
{
    NN_RESULT_DO(
        GetResourceManager().AssertValidBasicXpadPlayerNumber(playerNumber));
    NN_RESULT_DO(
        GetResourceManager().GetXpadMappingManager(playerNumber)
                            .ResetBasicXpadGenericPadMap());
    NN_RESULT_SUCCESS;
}

::nn::Result GetXpadKeyboardMap(::nn::settings::BasicXpadKeyboardMap* outValue,
                                int playerNumber) NN_NOEXCEPT
{
    NN_RESULT_DO(
        GetResourceManager().AssertValidBasicXpadPlayerNumber(playerNumber));
    NN_RESULT_DO(
        GetResourceManager().GetXpadMappingManager(playerNumber)
                            .GetBasicXpadKeyboardMap(outValue));
    NN_RESULT_SUCCESS;
}

::nn::Result SetXpadKeyboardMap(
    const ::nn::settings::BasicXpadKeyboardMap& value,
    int playerNumber) NN_NOEXCEPT
{
    NN_RESULT_DO(
        GetResourceManager().AssertValidBasicXpadPlayerNumber(playerNumber));
    NN_RESULT_DO(
        GetResourceManager().GetXpadMappingManager(playerNumber)
                            .SetBasicXpadKeyboardMap(value));
    NN_RESULT_SUCCESS;
}

::nn::Result ResetXpadKeyboardMap(int playerNumber) NN_NOEXCEPT
{
    NN_RESULT_DO(
        GetResourceManager().AssertValidBasicXpadPlayerNumber(playerNumber));
    NN_RESULT_DO(
        GetResourceManager().GetXpadMappingManager(playerNumber)
                            .ResetBasicXpadKeyboardMap());
    NN_RESULT_SUCCESS;
}

}}} // namespace nn::hid::detail
