﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Macro.h>
#include <nn/nn_SdkAssert.h>
#include <nn/hid/hid_AnalogStickState.h>
#include <nn/hid/hid_ControlPadTypes.h>
#include <nn/util/util_BitFlagSet.h>
#include <nn/xcd/xcd_Input.h>

#include "hid_NpadUtilTypes.h"

namespace nn { namespace hid { namespace detail {

inline system::DeviceTypeSet ConvertDeviceType(::nn::xcd::DeviceType deviceType, bool isAttachedToRail)
{
    switch (deviceType)
    {
    case ::nn::xcd::DeviceType_MiyabiLeft:
        return system::DeviceType::JoyConLeft::Mask;
    case ::nn::xcd::DeviceType_MiyabiRight:
        return system::DeviceType::JoyConRight::Mask;
    case ::nn::xcd::DeviceType_FullKey:
        return system::DeviceType::FullKeyController::Mask;
    case ::nn::xcd::DeviceType_Left:
        return (isAttachedToRail) ?
            system::DeviceType::JoyConLeft::Mask :
            system::DeviceType::HandheldJoyLeft::Mask;
    case ::nn::xcd::DeviceType_Right:
        return (isAttachedToRail) ?
            system::DeviceType::JoyConRight::Mask :
            system::DeviceType::HandheldJoyRight::Mask;
    default:
        return system::DeviceTypeSet();
    }
}

inline nn::xcd::DeviceType ConvertDeviceType(system::DeviceTypeSet deviceType)
{
    if ((deviceType & DeviceTypeMask_JoyLefts).IsAnyOn())
    {
        return ::nn::xcd::DeviceType_Left;
    }
    else if ((deviceType & DeviceTypeMask_JoyRights).IsAnyOn())
    {
        return ::nn::xcd::DeviceType_Right;
    }
    else if ((deviceType & system::DeviceType::SwitchProController::Mask).IsAnyOn())
    {
        return ::nn::xcd::DeviceType_FullKey;
    }

    return ::nn::xcd::DeviceType_Unknown;
}

inline system::InterfaceType ConvertInterfaceType(::nn::xcd::InterfaceType interfaceType)
{
    switch (interfaceType)
    {
    case nn::xcd::InterfaceType_Bluetooth:
        return system::InterfaceType_Bluetooth;
    case nn::xcd::InterfaceType_Usb:
        return system::InterfaceType_Usb;
    case nn::xcd::InterfaceType_Uart:
        return system::InterfaceType_Rail;
    default:
        return system::InterfaceType_Unknown;
    }
}

inline nn::xcd::InterfaceType ConvertInterfaceType(system::InterfaceType interfaceType)
{
    switch (interfaceType)
    {
    case system::InterfaceType_Bluetooth:
        return nn::xcd::InterfaceType_Bluetooth;
    case system::InterfaceType_Usb:
        return nn::xcd::InterfaceType_Usb;
    case system::InterfaceType_Rail:
        return nn::xcd::InterfaceType_Uart;
    default:
        return nn::xcd::InterfaceType_Uart;
    }
}

}}} // namespace nn::hid::detail
