﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/nn_TimeSpan.h>
#include <nn/nn_Windows.h>
#include <nn/os/os_TimerEvent.h>

#include "hid_ActivationCount.h"
#include "hid_WindowsGenericPadAccessor-os.win.h"

namespace nn { namespace hid { namespace detail {

//!< 汎用コントローラのブローカを扱うクラスです。
class WindowsGenericPadBroker final
{
    NN_DISALLOW_COPY(WindowsGenericPadBroker);
    NN_DISALLOW_MOVE(WindowsGenericPadBroker);

public:
    //!< サンプリング間隔
    static const ::nn::TimeSpan SamplingInterval;

private:
    //!< アクティブ化された回数
    ActivationCount m_ActivationCount;

    //!< タイマーイベント
    ::nn::os::TimerEventType* m_pTimerEvent;

    //!< 処理中の汎用コントローラの識別子
    uint32_t m_FocusedGenericPadId;

    //!< 汎用コントローラの数
    uint32_t m_GenericPadCount;

    //!< 汎用コントローラの能力
    WindowsGenericPadAbility m_GenericPadAbilities[16];

    //!< Joystick のハンドル
    HANDLE m_JoystickHandles[16];

    //!< デバイス名
    char m_DeviceName[NN_ARRAY_SIZE(WindowsGenericPadAbility::deviceName)];

public:
    WindowsGenericPadBroker() NN_NOEXCEPT;

    //!< タイマーイベントを設定します。
    void SetTimerEvent(::nn::os::TimerEventType* pTimerEvent) NN_NOEXCEPT;

    //!< ブローカをアクティブ化します。
    ::nn::Result Activate() NN_NOEXCEPT;

    //!< ブローカを非アクティブ化します。
    ::nn::Result Deactivate() NN_NOEXCEPT;

    //!< 汎用コントローラの割り当て状態を解決します。
    void Sample() NN_NOEXCEPT;

private:
    //!< 汎用コントローラの割り当て状態を更新します。
    void Update() NN_NOEXCEPT;
};

}}} // namespace nn::hid::detail
