﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "hid_VibrationValueQueue.h"

namespace nn { namespace hid { namespace detail {

namespace {

int s_QueuePosition = 0;
nn::hid::VibrationDeviceHandle s_Handles[SendableVibrationValueCountMax];
nn::hid::VibrationValue s_Values[SendableVibrationValueCountMax];

}

Result EnqueueVibrationValue(const VibrationDeviceHandle& handle, const VibrationValue& value) NN_NOEXCEPT
{
    if (s_QueuePosition >= SendableVibrationValueCountMax)
    {
        NN_RESULT_DO(FlushEnqueuedVibrationValues());
    }

    s_Handles[s_QueuePosition] = handle;
    s_Values[s_QueuePosition] = value;
    s_QueuePosition++;

    NN_RESULT_SUCCESS;
}

Result FlushEnqueuedVibrationValues() NN_NOEXCEPT
{
    if (s_QueuePosition > 0)
    {
        NN_RESULT_DO(SendVibrationValues(s_Handles, s_Values, s_QueuePosition));
        s_QueuePosition = 0;
    }

    NN_RESULT_SUCCESS;
}

}}} // namespace nn::hid::detail
