﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Common.h>
#include <nn/nn_Macro.h>
#include <nn/nn_Result.h>
#include <nn/hid/hid_IHidSystemServer.sfdl.h>
#include <nn/hid/hid_ResultPrivate.h>
#include <nn/hid/system/hid_Result.h>
#include <nn/hid/system/hid_Npad.h>
#include <nn/result/result_HandlingUtility.h>
#include <nn/sf/sf_ISharedObject.h>

#include "hid_UsbFullKeyImpl.h"
#include "hid_HidServer.h"
#include "hid_HidSystemServer.h"

namespace nn { namespace hid { namespace detail {

::nn::Result IsUsbFullKeyControllerEnabled(bool* pOutValue) NN_NOEXCEPT
{
    NN_SDK_REQUIRES_NOT_NULL(pOutValue);

    auto pProxy = ::nn::sf::SharedPointer<IHidSystemServer>();
    CreateHidSystemServerProxy(&pProxy);

    NN_RESULT_DO(pProxy->IsUsbFullKeyControllerEnabled(pOutValue));
    NN_RESULT_SUCCESS;
}

::nn::Result EnableUsbFullKeyController(bool enabled) NN_NOEXCEPT
{
    auto pProxy = ::nn::sf::SharedPointer<IHidSystemServer>();
    CreateHidSystemServerProxy(&pProxy);

    NN_RESULT_DO(pProxy->EnableUsbFullKeyController(enabled));
    NN_RESULT_SUCCESS;
}

::nn::Result IsUsbConnected(bool* pOutValue, system::UniquePadId id) NN_NOEXCEPT
{
    NN_SDK_REQUIRES_NOT_NULL(pOutValue);

    auto pProxy = ::nn::sf::SharedPointer<IHidSystemServer>();
    CreateHidSystemServerProxy(&pProxy);

    NN_RESULT_DO(pProxy->IsUsbConnected(pOutValue, id));
    NN_RESULT_SUCCESS;
}

::nn::Result IsUsbFullKeyControllerEnabledForApplication(bool* pOutValue) NN_NOEXCEPT
{
    NN_SDK_REQUIRES_NOT_NULL(pOutValue);

    auto pProxy = ::nn::sf::SharedPointer<IHidServer>();
    CreateHidServerProxy(&pProxy);

    NN_RESULT_DO(pProxy->IsUsbFullKeyControllerEnabled(pOutValue));
    NN_RESULT_SUCCESS;
}

::nn::Result EnableUsbFullKeyControllerForApplication(bool enabled) NN_NOEXCEPT
{
    auto pProxy = ::nn::sf::SharedPointer<IHidServer>();
    CreateHidServerProxy(&pProxy);

    NN_RESULT_DO(pProxy->EnableUsbFullKeyController(enabled));
    NN_RESULT_SUCCESS;
}

::nn::Result IsUsbFullKeyControllerConnectedForApplication(bool* pOutValue, const NpadIdType& id) NN_NOEXCEPT
{
    auto pProxy = ::nn::sf::SharedPointer<IHidServer>();
    CreateHidServerProxy(&pProxy);

    NN_RESULT_DO(pProxy->IsUsbFullKeyControllerConnected(pOutValue, id));
    NN_RESULT_SUCCESS;
}

}}} // namespace nn::hid::detail
