﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Macro.h>
#include <nn/nn_Result.h>
#include <nn/nn_SdkAssert.h>
#include <nn/hid/hid_ResultPrivate.h>
#include <nn/hid/hid_TouchScreen.h>
#include <nn/result/result_HandlingUtility.h>

#include "hid_TouchScreenDriver-os.horizon.stub.h"

namespace nn { namespace hid { namespace detail {

TouchScreenDriver::TouchScreenDriver() NN_NOEXCEPT
    : m_ActivationCount()
    , m_SamplingNumber(0)
{
    // 何もしない
}

TouchScreenDriver::~TouchScreenDriver() NN_NOEXCEPT
{
    // 何もしない
}

::nn::Result TouchScreenDriver::Activate() NN_NOEXCEPT
{
    NN_RESULT_THROW_UNLESS(!m_ActivationCount.IsMax(),
                           ResultTouchScreenDriverActivationUpperLimitOver());

    // このインスタンスからアクティブ化した回数をインクリメント
    ++m_ActivationCount;

    NN_RESULT_SUCCESS;
}

::nn::Result TouchScreenDriver::Deactivate() NN_NOEXCEPT
{
    NN_RESULT_THROW_UNLESS(!m_ActivationCount.IsZero(),
                           ResultTouchScreenDriverDeactivationLowerLimitOver());

    // このインスタンスからアクティブ化した回数をデクリメント
    --m_ActivationCount;

    NN_RESULT_SUCCESS;
}

::nn::Result TouchScreenDriver::Wake() NN_NOEXCEPT
{
    NN_SDK_REQUIRES(!m_ActivationCount.IsZero());
    NN_RESULT_SUCCESS;
}

::nn::Result TouchScreenDriver::Sleep() NN_NOEXCEPT
{
    NN_SDK_REQUIRES(!m_ActivationCount.IsZero());
    NN_RESULT_SUCCESS;
}

void TouchScreenDriver::GetState(TouchScreenState<TouchStateCountMax>* pOutValue
                                 ) NN_NOEXCEPT
{
    NN_SDK_REQUIRES_NOT_NULL(pOutValue);
    NN_SDK_REQUIRES(!m_ActivationCount.IsZero());

    // タッチスクリーンの入力状態を初期化
    *pOutValue = TouchScreenState<TouchStateCountMax>();

    pOutValue->samplingNumber = m_SamplingNumber++;
}

}}} // namespace nn::hid::detail
