﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Macro.h>
#include <nn/nn_Result.h>
#include <nn/bpc/bpc.h>
#include <nn/hid/system/hid_SleepButton.h>
#include <nn/os/os_SystemEvent.h>

#include "hid_ActivationCount.h"
#include "hid_ISleepButtonDriver.h"

namespace nn { namespace hid { namespace detail {

class SleepButtonDriver final : public ISleepButtonDriver
{
    NN_DISALLOW_COPY(SleepButtonDriver);
    NN_DISALLOW_MOVE(SleepButtonDriver);

private:
    //!< このインスタンスからドライバがアクティブ化された回数
    ActivationCount m_ActivationCount;

    //!< サンプリング番号
    int64_t m_SamplingNumber;

    //!< システムイベント
    ::nn::os::SystemEventType m_SystemEvent;

    //!< 入力状態
    ::nn::bpc::SleepButtonState m_State;

public:
    SleepButtonDriver() NN_NOEXCEPT;

    virtual ~SleepButtonDriver() NN_NOEXCEPT NN_OVERRIDE;

    virtual ::nn::Result Activate() NN_NOEXCEPT NN_OVERRIDE;

    virtual ::nn::Result Deactivate() NN_NOEXCEPT NN_OVERRIDE;

    virtual void GetState(::nn::hid::system::SleepButtonState* pOutValue
                          ) NN_NOEXCEPT NN_OVERRIDE;
};

}}} // namespace nn::hid::detail
