﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Macro.h>
#include <nn/nn_Result.h>
#include <nn/hid/hid_NpadCommonTypes.h>
#include <nn/hid/hid_NpadJoyCommon.h>

namespace nn { namespace hid { namespace detail {

::nn::Result SetSupportedNpadStyleSet(::nn::hid::NpadStyleSet style) NN_NOEXCEPT;

::nn::Result GetSupportedNpadStyleSet(::nn::hid::NpadStyleSet* pOutValue) NN_NOEXCEPT;

::nn::Result SetSupportedNpadIdType(const ::nn::hid::NpadIdType* pNpadIds, int count) NN_NOEXCEPT;

::nn::Result SetNpadJoyHoldType(NpadJoyHoldType holdType) NN_NOEXCEPT;

::nn::Result GetNpadJoyHoldType(NpadJoyHoldType* pOutValue) NN_NOEXCEPT;

::nn::Result StartLrAssignmentMode() NN_NOEXCEPT;

::nn::Result StopLrAssignmentMode() NN_NOEXCEPT;

::nn::Result SetNpadHandheldActivationMode(NpadHandheldActivationMode mode) NN_NOEXCEPT;

::nn::Result GetNpadHandheldActivationMode(NpadHandheldActivationMode* pOutValue) NN_NOEXCEPT;

::nn::Result SetNpadCommunicationMode(NpadCommunicationMode mode) NN_NOEXCEPT;

::nn::Result GetNpadCommunicationMode(NpadCommunicationMode* pOutValue) NN_NOEXCEPT;

::nn::Result IsUnintendedHomeButtonInputProtectionEnabled(bool* pOutEnabled, const NpadIdType& id) NN_NOEXCEPT;

::nn::Result EnableUnintendedHomeButtonInputProtection(const NpadIdType& id, bool enabled) NN_NOEXCEPT;

}}} // namespace nn::hid::detail
