﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Macro.h>
#include <nn/nn_Result.h>
#include <nn/hid/hid_ConsoleSixAxisSensor.h>
#include <nn/hid/tmp/hid_ConsoleSixAxisSensor.h>

namespace nn { namespace hid { namespace detail {

class IConsoleSixAxisSensorDriver
{
public:
    virtual ~IConsoleSixAxisSensorDriver() NN_NOEXCEPT { /* 何もしない */ }

    virtual ::nn::Result Activate() NN_NOEXCEPT = 0;

    virtual ::nn::Result Deactivate() NN_NOEXCEPT = 0;

    virtual ::nn::Result Wake() NN_NOEXCEPT = 0;

    virtual ::nn::Result Sleep() NN_NOEXCEPT = 0;

    virtual ::nn::Result Start(::nn::TimeSpan samplingInterval) NN_NOEXCEPT = 0;

    virtual ::nn::Result Stop() NN_NOEXCEPT = 0;

    virtual int GetStates(tmp::SixAxisSensorCountState* pOutValue, int count) NN_NOEXCEPT = 0;

    virtual ::nn::Result GetConsoleSixAxisSensorCalibrationValues(tmp::ConsoleSixAxisSensorCalibrationValues* pOutValues) NN_NOEXCEPT = 0;

    virtual void ConvertAcceleration(nn::util::Float3* outValue,
                                     const tmp::SensorCountState& acceleration) const NN_NOEXCEPT = 0;

    virtual void ConvertAngularVelocity(nn::util::Float3* outValue,
                                        const tmp::SensorCountState& angularVelocity) const NN_NOEXCEPT = 0;
};

}}} // namespace nn::hid::detail
