﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <type_traits>
#include <nn/nn_Common.h>
#include <nn/hid/hid_Gesture.h>
#include <nn/TargetConfigs/build_Base.h>
#include <nn/util/util_MathTypes.h>

#include "hid_RingLifo.h"

namespace nn { namespace hid { namespace detail {

//!< LIFO 対応版のジェスチャの状態を表す構造体です。
struct GestureDummyState final
{
    int64_t samplingNumber;
    int64_t contextNumber;
    int32_t _type;
    int32_t _direction;
    int32_t x;
    int32_t y;
    int32_t deltaX;
    int32_t deltaY;
    ::nn::util::Float2 velocity;
    GestureAttributeSet attributes;
    float scale;
    float rotationAngle;
    int32_t pointCount;
    GesturePoint points[GesturePointCountMax];
};

class GestureLifo final
    : public RingLifo<GestureDummyState, GestureStateCountMax>
{
public:
    GestureLifo() NN_NOEXCEPT { /* 何もしない */ }

    //!< LIFO に要素を追加します。
    void Append(const GestureState& value) NN_NOEXCEPT
    {
        this->AppendImpl(*reinterpret_cast<const GestureDummyState*>(&value));
    }

    //!< LIFO から要素を読み出します。任意のタイミングでスレッドセーフです。
    int Read(GestureState* buffer, int bufferCount) const NN_NOEXCEPT
    {
        return this->ReadImpl(
            reinterpret_cast<GestureDummyState*>(buffer), bufferCount);
    }
};

#ifdef NN_BUILD_CONFIG_TOOLCHAIN_CLANG
NN_STATIC_ASSERT(::std::is_standard_layout<GestureLifo>::value);
#endif

}}} // namespace nn::hid::detail
