﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Macro.h>
#include <nn/nn_Result.h>
#include <nn/os/os_SystemEvent.h>

#include <nn/hid/system/hid_FirmwareUpdate.h>
#include <nn/hid/system/hid_UniquePad.h>

namespace nn { namespace hid { namespace system { namespace detail {

::nn::Result InitializeFirmwareUpdate() NN_NOEXCEPT;

::nn::Result StartFirmwareUpdate(system::FirmwareUpdateDeviceHandle* pOutHandle,
                                 system::UniquePadId id) NN_NOEXCEPT;

::nn::Result AbortFirmwareUpdate() NN_NOEXCEPT;

::nn::Result GetFirmwareVersion(system::FirmwareVersion* pOutValue,
                                UniquePadId id) NN_NOEXCEPT;

::nn::Result GetAvailableFirmwareVersion(system::FirmwareVersion* pOutValue,
                                      UniquePadId id) NN_NOEXCEPT;

::nn::Result IsFirmwareUpdateAvailable(bool* pOutIsAvailable,
                                       UniquePadId id) NN_NOEXCEPT;

::nn::Result CheckFirmwareUpdateRequired(FirmwareUpdateRequiredReason* pOutReason,
                                         UniquePadId id) NN_NOEXCEPT;

::nn::Result GetFirmwareUpdateState(system::FirmwareUpdateState* pOutStage,
                                    const system::FirmwareUpdateDeviceHandle& handle) NN_NOEXCEPT;

::nn::Result SetFirmwareHotfixUpdateSkipEnabled(bool isEnabled) NN_NOEXCEPT;

}}}} // namespace nn::hid::system::detail
