﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <atomic>
#include <nn/nn_Macro.h>
#include <nn/nn_Result.h>
#include <nn/nn_Windows.h>
#include <nn/os/os_SdkMutex.h>

namespace nn { namespace hid { namespace detail {

class FileMappingObject final
{
    NN_DISALLOW_COPY(FileMappingObject);
    NN_DISALLOW_MOVE(FileMappingObject);

private:
    static const int NameLengthMax = 64;

    static const int MutexSuffixLength = 6;

    static const char* const MutexSuffix;

    // 初期化処理排他用ミューテックス
    ::nn::os::SdkMutex m_Mutex;

    //!< ファイルマッピングオブジェクトのバイト数
    size_t m_Count;

    //!< ファイルマッピングオブジェクトの名前
    char m_Name[NameLengthMax + 1];

    //!< ファイルマッピングオブジェクトのハンドル
    HANDLE m_Handle;

    //!< ファイルマッピングオブジェクト操作排他用ミューテックスの名前
    char m_MutexName[NameLengthMax + MutexSuffixLength + 1];

    //!< ファイルマッピングオブジェクト操作排他用ミューテックスのハンドル
    ::std::atomic<HANDLE> m_MutexHandle;

    //!< ファイルマッピングオブジェクトを指すメモリアドレス
    ::std::atomic<LPVOID> m_Address;

public:
    FileMappingObject(DWORD count, const char* name) NN_NOEXCEPT;

    ~FileMappingObject() NN_NOEXCEPT;

    //!< ファイルマッピングオブジェクトのバイト数を返します。
    size_t GetCount() const NN_NOEXCEPT;

    //!< ファイルマッピングオブジェクトに対する操作を排他します。
    ::nn::Result Lock() NN_NOEXCEPT;

    //!< ファイルマッピングオブジェクトに対する操作の排他を解除します。
    void Unlock() NN_NOEXCEPT;

    //!< ファイルマッピングオブジェクトを指すメモリアドレスを取得します。
    ::nn::Result GetAddress(LPVOID* pOutAddress, bool* pOutExists) NN_NOEXCEPT;
};

}}} // namespace nn::hid::detail
