﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Macro.h>
#include <nn/nn_Result.h>
#include <nn/result/result_HandlingUtility.h>
#include <nn/settings/settings_DebugPad.h>

#include "hid_DebugPadMapImpl.h"
#include "hid_ResourceManager-os.win.h"

namespace nn { namespace hid { namespace detail {

::nn::Result GetDebugPadGenericPadMap(
    ::nn::settings::DebugPadGenericPadMap* outValue) NN_NOEXCEPT
{
    NN_RESULT_THROW(GetResourceManager().GetDebugPadMappingManager()
                                        .GetDebugPadGenericPadMap(outValue));
}

::nn::Result SetDebugPadGenericPadMap(
    const ::nn::settings::DebugPadGenericPadMap& value) NN_NOEXCEPT
{
    NN_RESULT_THROW(GetResourceManager().GetDebugPadMappingManager()
                                        .SetDebugPadGenericPadMap(value));
}

::nn::Result ResetDebugPadGenericPadMap() NN_NOEXCEPT
{
    GetResourceManager().GetDebugPadMappingManager()
                        .ResetDebugPadGenericPadMap();
    NN_RESULT_SUCCESS;
}

::nn::Result GetDebugPadKeyboardMap(
    ::nn::settings::DebugPadKeyboardMap* outValue) NN_NOEXCEPT
{
    NN_RESULT_THROW(GetResourceManager().GetDebugPadMappingManager()
                                        .GetDebugPadKeyboardMap(outValue));
}

::nn::Result SetDebugPadKeyboardMap(
    const ::nn::settings::DebugPadKeyboardMap& value) NN_NOEXCEPT
{
    GetResourceManager().GetDebugPadMappingManager()
                        .SetDebugPadKeyboardMap(value);
    NN_RESULT_SUCCESS;
}

::nn::Result ResetDebugPadKeyboardMap() NN_NOEXCEPT
{
    GetResourceManager().GetDebugPadMappingManager()
                        .ResetDebugPadKeyboardMap();
    NN_RESULT_SUCCESS;
}

}}} // namespace nn::hid::detail
