﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Macro.h>
#include <nn/nn_Result.h>
#include <nn/hid/hid_DebugPad.h>

#include "hid_ActivationCount.h"
#include "hid_IDebugPadDriver.h"
#include "hid_SystemButtonNotifier.h"

// ペアリングトリガーのため (削除予定)
#include <nn/os/os_Tick.h>
#include "hid_XcdDriver.h"

namespace nn { namespace hid { namespace detail {

class DebugPadDriver final : public IDebugPadDriver
{
    NN_DISALLOW_COPY(DebugPadDriver);
    NN_DISALLOW_MOVE(DebugPadDriver);

private:
    //!< ホームボタンの入力通知を行う Notifier
    SystemButtonNotifier m_HomeButtonNotifier;

    //!< アクティブ化した回数
    ActivationCount m_ActivationCount;

    //!< サンプリング番号
    int64_t m_SamplingNumber;

    //!< ペアリングトリガーのため (削除予定)
    ::nn::os::Tick m_TimeHomeTriggered;
    bool m_HomePressed;
    bool m_PairingTriggered;
    XcdDriver* m_pXcdDriver;

public:
    DebugPadDriver() NN_NOEXCEPT;

    virtual ~DebugPadDriver() NN_NOEXCEPT NN_OVERRIDE;

    //!< ホームボタンの入力通知を行う Notifier を設定します。
    void SetHomeButtonNotifier(SystemButtonNotifier value) NN_NOEXCEPT;

    virtual ::nn::Result Activate() NN_NOEXCEPT NN_OVERRIDE;

    virtual ::nn::Result Deactivate() NN_NOEXCEPT NN_OVERRIDE;

    virtual void GetState(DebugPadState* pOutValue) NN_NOEXCEPT NN_OVERRIDE;

    //!< ペアリングトリガーのため (削除予定)
    void SetXcdDriver(XcdDriver* pDriver) NN_NOEXCEPT;
};

}}} // namespace nn::hid::detail
