﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
 * @file
 * @brief   コントローラーサポートの UI 呼び出しに関する内部 API の宣言
 */

#pragma once

#include <nn/hid/system/hid_ControllerSupportArgPrivate.h>

//---------------------------------------------------------------------------
// C++ 関数の定義
//---------------------------------------------------------------------------

namespace nn { namespace hid { namespace detail {

//---------------------------------------------------------------------------
//
nn::Result ShowControllerSupportCore(
    ControllerSupportResultInfo* pOutValue,
    const ControllerSupportArg& arg,
    const system::ControllerSupportArgPrivate& argPrivate ) NN_NOEXCEPT;

nn::Result ShowControllerFirmwareUpdateCore(
    const ControllerFirmwareUpdateArg& arg,
    const system::ControllerSupportArgPrivate& argPrivate ) NN_NOEXCEPT;

}}} // namespace nn::hid::detail

