﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <type_traits>
#include <nn/nn_Common.h>
#include <nn/hid/hid_ConsoleSixAxisSensor.h>
#include <nn/hid/hid_SevenSixAxisSensor.h>
#include <nn/hid/tmp/hid_ConsoleSixAxisSensor.h>
#include <nn/hid/system/hid_SixAxisSensorAccurateCalibration.h>
#include <nn/TargetConfigs/build_Base.h>

#include "hid_RingLifo.h"

namespace nn { namespace hid { namespace detail {

class SevenSixAxisSensorStateLifo final : public RingLifo<SevenSixAxisSensorState, SevenSixAxisSensorStateCountMax>
{
public:
    SevenSixAxisSensorStateLifo() NN_NOEXCEPT { /* 何もしない */ }
};

#ifdef NN_BUILD_CONFIG_TOOLCHAIN_CLANG
NN_STATIC_ASSERT(::std::is_standard_layout<SevenSixAxisSensorStateLifo>::value);
#endif

class ConsoleSixAxisSensorInternalState final
{
    NN_DISALLOW_COPY(ConsoleSixAxisSensorInternalState);
    NN_DISALLOW_MOVE(ConsoleSixAxisSensorInternalState);

private:
    system::SixAxisSensorAccurateUserCalibrationState m_CalibrationState;

    bool m_IsSevenSixAxisSensorAtRest;

    float m_VerticalizationError;

    ::nn::util::Float3 m_GyroBias;

public:
    ConsoleSixAxisSensorInternalState() NN_NOEXCEPT
        : m_CalibrationState()
        , m_IsSevenSixAxisSensorAtRest(false)
        , m_VerticalizationError(0.f)
        , m_GyroBias(::nn::util::Float3())
    {
        m_CalibrationState.stage = system::SixAxisSensorAccurateUserCalibrationStage::SixAxisSensorAccurateUserCalibrationStage_InitialStage;
        m_CalibrationState.progress = 0.f;
    }

     ~ConsoleSixAxisSensorInternalState() NN_NOEXCEPT
     {
         // 何もしない
     }

public:

    system::SixAxisSensorAccurateUserCalibrationState GetConsoleSixAxisSensorUserCalibrationState() NN_NOEXCEPT
    {
        return m_CalibrationState;
    }

    void SetConsoleSixAxisSensorUserCalibrationState(const system::SixAxisSensorAccurateUserCalibrationState& state) NN_NOEXCEPT
    {
        m_CalibrationState = state;
    }

    bool GetSevenSixAxisSensorIsAtRest() const NN_NOEXCEPT
    {
        return m_IsSevenSixAxisSensorAtRest;
    }

    void SetSevenSixAxisSensorIsAtRest(const bool& isAtRest) NN_NOEXCEPT
    {
        m_IsSevenSixAxisSensorAtRest = isAtRest;
    }

    void Clear() NN_NOEXCEPT
    {
        m_IsSevenSixAxisSensorAtRest = false;
    }

    float GetVerticalizationError() const NN_NOEXCEPT
    {
        return m_VerticalizationError;
    }

    void SetVerticalizationError(const float& verticalizationError) NN_NOEXCEPT
    {
        m_VerticalizationError = verticalizationError;
    }

    ::nn::util::Float3 GetGyroBias() const NN_NOEXCEPT
    {
        return m_GyroBias;
    }

    void SetGyroBias(const ::nn::util::Float3& gyroBias) NN_NOEXCEPT
    {
        m_GyroBias = gyroBias;
    }
};

}}} // namespace nn::hid::detail
