﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Macro.h>
#include <nn/nn_Result.h>
#include <nn/nn_SdkAssert.h>
#include <nn/hid/hid_ResultPrivate.h>
#include <nn/hid/hid_ConsoleSixAxisSensor.h>
#include <nn/result/result_HandlingUtility.h>

#include "hid_ConsoleSixAxisSensorDriver.horizon.stub.h"

namespace nn { namespace hid { namespace detail {

ConsoleSixAxisSensorDriver::ConsoleSixAxisSensorDriver() NN_NOEXCEPT
    : m_ActivationCount()
    , m_SamplingNumber(0)
{
    // 何もしない
}

ConsoleSixAxisSensorDriver::~ConsoleSixAxisSensorDriver() NN_NOEXCEPT
{
    // 何もしない
}

::nn::Result ConsoleSixAxisSensorDriver::Activate() NN_NOEXCEPT
{
    NN_RESULT_THROW_UNLESS(!m_ActivationCount.IsMax(),
                           ResultConsoleSixAxisSensorDriverActivationUpperLimitOver());

    // このインスタンスからアクティブ化した回数をインクリメント
    ++m_ActivationCount;

    NN_RESULT_SUCCESS;
}

::nn::Result ConsoleSixAxisSensorDriver::Deactivate() NN_NOEXCEPT
{
    NN_RESULT_THROW_UNLESS(!m_ActivationCount.IsZero(),
                           ResultConsoleSixAxisSensorDriverDeactivationLowerLimitOver());

    // このインスタンスからアクティブ化した回数をデクリメント
    --m_ActivationCount;

    NN_RESULT_SUCCESS;
}

::nn::Result ConsoleSixAxisSensorDriver::Wake() NN_NOEXCEPT
{
    NN_SDK_REQUIRES(!m_ActivationCount.IsZero());
    NN_RESULT_SUCCESS;
}

::nn::Result ConsoleSixAxisSensorDriver::Sleep() NN_NOEXCEPT
{
    NN_SDK_REQUIRES(!m_ActivationCount.IsZero());
    NN_RESULT_SUCCESS;
}

::nn::Result ConsoleSixAxisSensorDriver::Start(::nn::TimeSpan samplingInterval) NN_NOEXCEPT
{
    // 何もしない
    NN_UNUSED(samplingInterval);
    NN_RESULT_SUCCESS;
}

::nn::Result ConsoleSixAxisSensorDriver::Stop() NN_NOEXCEPT
{
    // 何もしない
    NN_RESULT_SUCCESS;
}

int ConsoleSixAxisSensorDriver::GetStates(tmp::SixAxisSensorCountState* pOutValue, int count) NN_NOEXCEPT
{
    NN_UNUSED(count);

    NN_SDK_REQUIRES_NOT_NULL(pOutValue);
    NN_SDK_REQUIRES(!m_ActivationCount.IsZero());

    // 何もしない

    return 0;
}

::nn::Result ConsoleSixAxisSensorDriver::GetConsoleSixAxisSensorCalibrationValues(tmp::ConsoleSixAxisSensorCalibrationValues* pOutValues) NN_NOEXCEPT
{
    // 何もしない
    NN_UNUSED(pOutValues);
    NN_RESULT_SUCCESS;
}

void ConsoleSixAxisSensorDriver::ConvertAcceleration(nn::util::Float3* outValue,
                                                     const tmp::SensorCountState& acceleration) const NN_NOEXCEPT
{
    // 何もしない
    NN_UNUSED(outValue);
    NN_UNUSED(acceleration);
}

void ConsoleSixAxisSensorDriver::ConvertAngularVelocity(nn::util::Float3* outValue,
                                                        const tmp::SensorCountState& angularVelocity) const NN_NOEXCEPT
{
    // 何もしない
    NN_UNUSED(outValue);
    NN_UNUSED(angularVelocity);
}

}}} // namespace nn::hid::detail
