﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Common.h>
#include <nn/nn_Macro.h>
#include <nn/btm/btm.h>
#include <nn/xcd/xcd_BluetoothConnection.h>

#include "hid_AppletResourceUserId.h"
#include "hid_BluetoothMode.h"

namespace nn { namespace hid { namespace detail {

bool IsBluetoothEnabled() NN_NOEXCEPT
{
    bool isEnabled = true;
    // ジョイコンが本体から取り外された
    ::nn::btm::InitializeBtmInterface();
    ::nn::btm::BtmState btmState;
    ::nn::btm::GetState(&btmState);

    if (btmState == ::nn::btm::BtmState_RadioOff || btmState == ::nn::btm::BtmState_RadioOffSlept)
    {
        isEnabled = false;
    }
    ::nn::btm::FinalizeBtmInterface();

    return isEnabled;
}

}}} // namespace nn::hid::detail
