﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/fs/fs_File.h>
#include <movie/Extractor.h>
#include <nn/util/util_Optional.h>
#include <nn/capsrv/capsrv_ScreenShotAttribute.h>

NN_PRAGMA_PUSH_WARNINGS
#pragma GCC diagnostic ignored "-Wunused-parameter"
#pragma GCC diagnostic ignored "-Wmismatched-tags"
#include <media/stagefright/MediaCodec.h>
#include <media/stagefright/MediaMuxer.h>
#include <media/stagefright/MPEG4WriterStream.h>
NN_PRAGMA_POP_WARNINGS

#include <nn/nn_Abort.h>
#include <nn/nn_SdkAssert.h>
#include <nn/result/result_HandlingUtility.h>

namespace nn { namespace grcsrv { namespace trimming {

namespace detail {

class FileStreamReader final : public movie::ClientStreamReader
{
private:

    bool m_Initialized = false;
    bool m_Opened = false;
    fs::FileHandle m_Handle;
    int64_t m_FileSize = 0;
    Result m_LastResult;

public:

    Result Initialize(nn::fs::FileHandle handle) NN_NOEXCEPT;
    Result GetLastResult() const NN_NOEXCEPT;

private:

    virtual bool Open(const char*, void** pOut) NN_OVERRIDE;
    virtual size_t ReadAt(void* this_, int64_t offset, void* buffer, size_t size) NN_OVERRIDE;
    virtual bool Close(void* this_) NN_OVERRIDE;
    virtual void GetSize(void* this_, int64_t* pOut) NN_OVERRIDE;

};

} // namespace detail

class MovieTrimmerImpl
{
public:

    Result Initialize(fs::FileHandle handle, void* buffer, size_t bufferSize) NN_NOEXCEPT;
    Result ReadHeader() NN_NOEXCEPT;
    Result Trim(int* pFrameCount, fs::FileHandle handle, int beginIndex, int endIndex, const capsrv::ScreenShotAttribute& attribute) NN_NOEXCEPT;

private:

    detail::FileStreamReader m_Reader;
    void* m_WorkBuffer;
    size_t m_WorkBufferSize;
    util::optional<movie::Extractor> m_pDemuxer;

    int32_t m_VideoTrackIndex = -1;
    int32_t m_AudioTrackIndex = -1;
    android::sp<android::AMessage> m_VideoFormatHeader;
    android::sp<android::AMessage> m_AudioFormatHeader;
    Result ReadTrack(int index) NN_NOEXCEPT;
    static Result ReadVideoTrack(android::sp<android::AMessage>* pOut, const movie::MediaData& trackFormat) NN_NOEXCEPT;
    static Result ReadAudioTrack(android::sp<android::AMessage>* pOut, const movie::MediaData& trackFormat) NN_NOEXCEPT;

    Result InitializeImpl(fs::FileHandle handle, void* buffer, size_t bufferSize) NN_NOEXCEPT;
    Result ReadHeaderImpl() NN_NOEXCEPT;
    Result TrimImpl(int* pFrameCount, fs::FileHandle handle, int beginIndex, int endIndex, const capsrv::ScreenShotAttribute& attribute) NN_NOEXCEPT;

};

}}}
