﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/nn_Abort.h>
#include <nn/nn_SdkAssert.h>
#include <nn/result/result_HandlingUtility.h>
#include <movie/Extractor.h>

NN_PRAGMA_PUSH_WARNINGS
#pragma GCC diagnostic ignored "-Wunused-parameter"
#pragma GCC diagnostic ignored "-Wmismatched-tags"
#include <media/stagefright/MediaCodec.h>
#include <media/stagefright/MediaMuxer.h>
#include <media/stagefright/MPEG4WriterStream.h>
#include <media/stagefright/MediaErrors.h>
NN_PRAGMA_POP_WARNINGS

namespace nn { namespace grcsrv { namespace trimming { namespace detail {

class AndroidStatus
{
private:

    android::status_t m_Status;

public:

    AndroidStatus() NN_NOEXCEPT
        : m_Status(0)
    {
    }

    NN_IMPLICIT AndroidStatus(android::status_t status) NN_NOEXCEPT
        : m_Status(status)
    {
    }

    android::status_t GetStatus() const NN_NOEXCEPT
    {
        return m_Status;
    }

};

movie::Status AndroidStatusToMovieStatus(android::status_t androidResult) NN_NOEXCEPT;

class AndroidUtils
{
public:

    static AndroidStatus ConvertMediaDataToMessage(const movie::MediaData* meta, android::sp<android::AMessage> *format) NN_NOEXCEPT;

};

}}}}
