﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include "../grcsrvOffscreen_Macro.h"
NN_PRAGMA_PUSH_WARNINGS
NN_GRCSRV_SUPPRESS_MOVIE_WARNINGS
#include <media/stagefright/MediaCodec.h>
#include <nvnflinger_service.h>
NN_PRAGMA_POP_WARNINGS

#include "../util/grcsrv_TQueue.h"

namespace nn{ namespace grcsrv{ namespace offscreen{ namespace detail{

    struct VideoRendererToVideoCaptureValue
    {
        int index;
        android::IGraphicBufferConsumer::BufferItem item;
        android::sp<android::GraphicBuffer> buffer;
        int64_t timestampUs;
        bool isFinishRequested;
    };

    struct VideoCaptureToVideoRendererValue
    {
        int index; // GraphicBufferQueue 上のインデックス
    };

    struct VideoCaptureToVideoEncoderValue
    {
        int index;
        android::sp<android::GraphicBuffer> buffer;
        int64_t timestampUs;
        bool isFinishRequested;
        bool isAbortRequested;
    };

    struct VideoEncoderToVideoCaptureValue
    {
        int index;
        android::sp<android::GraphicBuffer> buffer;
    };

    struct AudioRendererToAudioEncoderValue
    {
        int index;
        android::sp<android::ABuffer> buffer;
        int64_t timestampUs;
        bool isFinishRequested;
        bool isAbortRequested;
    };

    struct AudioEncoderToAudioRendererValue
    {
        int index;
        android::sp<android::ABuffer> buffer;
    };

    // 終了要求を投げるので行きのキャパシティは多めにしておく。
    // 行き（Renderer->Capture->Encoder）だけ多くすれば十分かもしれない。
    typedef util::TQueue<VideoRendererToVideoCaptureValue, VideoCaptureImageBufferCount + 2, true> VideoRendererToVideoCaptureQueue;
    typedef util::TQueue<VideoCaptureToVideoRendererValue, VideoCaptureImageBufferCount + 2, true> VideoCaptureToVideoRendererQueue;
    typedef util::TQueue<VideoCaptureToVideoEncoderValue , VideoCaptureImageBufferCount + 2, true> VideoCaptureToVideoEncoderQueue;
    typedef util::TQueue<VideoEncoderToVideoCaptureValue , VideoCaptureImageBufferCount + 2, true> VideoEncoderToVideoCaptureQueue;
    typedef util::TQueue<AudioRendererToAudioEncoderValue, 4, true> AudioRendererToAudioEncoderQueue;
    typedef util::TQueue<AudioEncoderToAudioRendererValue, 2, true> AudioEncoderToAudioRendererQueue;

}}}}
