﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/grc/grc_Api.h>

#include <nn/nn_Common.h>
#include <nn/nn_Assert.h>
#include <nn/nn_Abort.h>
#include <utility>
#include <memory>
#include <nn/os/os_TransferMemoryApi.h>
#include <nn/result/result_HandlingUtility.h>
#include <nn/sf/sf_ShimLibraryUtility.h>
#include <nn/grcsrv/grcsrv_GrcServices.sfdl.h>

namespace nn { namespace grc {

namespace {

sf::ProxyObjectAllocator<10> g_ProxyObjectAllocator = NN_SF_PROXY_OBJECT_ALLOCATOR_INITIALIZER;

}

Result InitializeByHipc() NN_NOEXCEPT
{
    g_ProxyObjectAllocator.Initialize();
    NN_RESULT_SUCCESS;
}

void FinalizeByHipc() NN_NOEXCEPT
{
    g_ProxyObjectAllocator.Finalize();
}

Result CreateContinuousRecorder(sf::SharedPointer<grcsrv::IContinuousRecorder>* pOut, sf::NativeHandle workMemoryHandle, uint64_t workMemorySize, const ContinuousRecordingParameter& parameter) NN_NOEXCEPT
{
    grcsrv::ContinuousRecordingParameter p = {};
    static_assert(sizeof(parameter) <= sizeof(p), "needs to modify SFDL");
    std::memcpy(&p, &parameter, sizeof(parameter));
    auto ppService = sf::CreateHipcProxyByName<grcsrv::IGrcService>(g_ProxyObjectAllocator.GetMemoryResource(), "grc:c");
    NN_RESULT_DO(ppService);
    return (*ppService)->CreateContinuousRecorder(pOut, std::move(workMemoryHandle), workMemorySize, p);
}

Result CreateGameMovieTrimmer(sf::SharedPointer<grcsrv::IGameMovieTrimmer>* pOut, sf::NativeHandle workMemoryHandle, uint64_t workMemorySize) NN_NOEXCEPT
{
    auto ppService = sf::CreateHipcProxyByName<grcsrv::IGrcService>(g_ProxyObjectAllocator.GetMemoryResource(), "grc:c");
    NN_RESULT_DO(ppService);
    return (*ppService)->CreateGameMovieTrimmer(pOut, std::move(workMemoryHandle), workMemorySize);
}

Result CreateOffscreenRecorder(sf::SharedPointer<grcsrv::IOffscreenRecorder>* pOut, sf::NativeHandle workMemoryHandle, uint64_t workMemorySize) NN_NOEXCEPT
{
    auto ppService = sf::CreateHipcProxyByName<grcsrv::IGrcService>(g_ProxyObjectAllocator.GetMemoryResource(), "grc:c");
    NN_RESULT_DO(ppService);
    return (*ppService)->CreateOffscreenRecorder(pOut, std::move(workMemoryHandle), workMemorySize);
}

Result CreateMovieMakerForApplication(sf::SharedPointer<grcsrv::IMovieMaker>* pOut, applet::AppletResourceUserId aruid, ncm::ApplicationId applicationId) NN_NOEXCEPT
{
    auto ppService = sf::CreateHipcProxyByName<grcsrv::IGrcService>(g_ProxyObjectAllocator.GetMemoryResource(), "grc:c");
    NN_RESULT_DO(ppService);
    return (*ppService)->CreateMovieMakerForApplication(pOut, aruid, applicationId);
}

void SetOffscreenRecorderCheckPointForTesting(uint64_t value) NN_NOEXCEPT
{
    auto ppService = sf::CreateHipcProxyByName<grcsrv::IGrcService>(g_ProxyObjectAllocator.GetMemoryResource(), "grc:c");
    NN_ABORT_UNLESS_RESULT_SUCCESS(ppService);
    NN_ABORT_UNLESS_RESULT_SUCCESS((*ppService)->SetOffscreenRecorderCheckPointForTesting(value));
}

}}
