﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_StaticAssert.h>

#include <nn/gfx/gfx_TextureInfo.h>

namespace nn {
namespace gfx {

void TextureInfo::SetDefault() NN_NOEXCEPT
{
    SetImageStorageDimension( ImageStorageDimension_2d );
    SetImageFormat( ImageFormat_Undefined );
    SetGpuAccessFlags( 0 );
    SetTileMode( TileMode_Optimal );
    SetWidth( 1 );
    SetHeight( 1 );
    SetDepth( 1 );
    SetMipCount( 1 );
    SetArrayLength( 0 );
    SetSwizzle( 0 );
    SetMultiSampleCount( 1 );
}

void TextureViewInfo::SetDefault() NN_NOEXCEPT
{
    SetImageDimension( ImageDimension_2d );
    SetDepthStencilTextureMode( DepthStencilFetchMode_DepthComponent );
    SetImageFormat( ImageFormat_Undefined );
    EditSubresourceRange().SetDefault();
    SetChannelMapping( ChannelMapping_Red, ChannelMapping_Green,
        ChannelMapping_Blue, ChannelMapping_Alpha );
    SetTexturePtr( NULL );
}

void ColorTargetViewInfo::SetDefault() NN_NOEXCEPT
{
    SetImageDimension( nn::gfx::ImageDimension_2d );
    SetImageFormat( ImageFormat_Undefined );
    SetMipLevel( 0 );
    EditArrayRange().SetDefault();
    SetTexturePtr( NULL );
}

void DepthStencilViewInfo::SetDefault() NN_NOEXCEPT
{
    SetImageDimension( nn::gfx::ImageDimension_2d );
    SetMipLevel( 0 );
    EditArrayRange().SetDefault();
    SetTexturePtr( NULL );
}

void TextureMipRange::SetDefault() NN_NOEXCEPT
{
    SetMinMipLevel( 0 );
    SetMipCount( 1 );
}

void TextureArrayRange::SetDefault() NN_NOEXCEPT
{
    SetBaseArrayIndex( 0 );
    SetArrayLength( 1 );
}

void TextureSubresourceRange::SetDefault() NN_NOEXCEPT
{
    EditMipRange().SetDefault();
    EditArrayRange().SetDefault();
}

void TextureSubresource::SetDefault() NN_NOEXCEPT
{
    SetMipLevel( 0 );
    SetArrayIndex( 0 );
}

void TextureCopyRegion::SetDefault() NN_NOEXCEPT
{
    SetOffsetU( 0 );
    SetOffsetV( 0 );
    SetOffsetW( 0 );
    SetWidth( 1 );
    SetHeight( 1 );
    SetDepth( 1 );
    EditSubresource().SetDefault();
    SetArrayLength( 1 );
}

void BufferTextureCopyRegion::SetDefault() NN_NOEXCEPT
{
    SetBufferOffset( 0 );
    SetBufferImageWidth( 0 );
    SetBufferImageHeight( 0 );
    EditTextureCopyRegion().SetDefault();
}

NN_STATIC_ASSERT( sizeof( TextureMipRangeData ) == 16 );
NN_STATIC_ASSERT( sizeof( TextureArrayRangeData ) == 16 );
NN_STATIC_ASSERT( sizeof( TextureSubresourceRangeData ) == 32 );
NN_STATIC_ASSERT( sizeof( TextureInfoData ) == 64 );
NN_STATIC_ASSERT( sizeof( TextureViewInfoData ) == 64 );
NN_STATIC_ASSERT( sizeof( ColorTargetViewInfoData ) == 48 );
NN_STATIC_ASSERT( sizeof( DepthStencilViewInfoData ) == 48 );

}
}
