﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_StaticAssert.h>

#include <nn/gfx/gfx_BufferInfo.h>

namespace nn {
namespace gfx {

void BufferInfo::SetDefault() NN_NOEXCEPT
{
    SetSize( 0 );
    SetGpuAccessFlags( 0 );
}

void BufferTextureViewInfo::SetDefault() NN_NOEXCEPT
{
    SetImageFormat( nn::gfx::ImageFormat_Undefined );
    SetOffset( 0 );
    SetSize( 0 );
    SetBufferPtr( NULL );
}

NN_STATIC_ASSERT( sizeof( BufferInfoData ) == 16 );
NN_STATIC_ASSERT( sizeof( BufferTextureViewInfoData ) == 32 );

}
}
