﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/util/util_BytePtr.h>

#include <nn/gfx/gfx_MemoryPoolInfo.h>

#include <nn/gfx/detail/gfx_MemoryPool-api.gx.2.h>

#include "gfx_GxHelper.h"

namespace nn {
namespace gfx {
namespace detail {

typedef ApiVariationGx2 Target;

size_t MemoryPoolImpl< Target >::GetPoolMemoryAlignment(
    DeviceImpl< Target >*, const InfoType& ) NN_NOEXCEPT
{
    return 16384;
}

size_t MemoryPoolImpl< Target >::GetPoolMemorySizeGranularity(
    DeviceImpl< Target >*, const InfoType& ) NN_NOEXCEPT
{
    return 1;
}

MemoryPoolImpl< Target >::MemoryPoolImpl() NN_NOEXCEPT
{
    this->state = State_NotInitialized;
}

MemoryPoolImpl< Target >::~MemoryPoolImpl() NN_NOEXCEPT
{
    NN_SDK_ASSERT( this->state == State_NotInitialized );
}

void MemoryPoolImpl< Target >::Initialize(
    DeviceImpl< Target >*, const InfoType& info ) NN_NOEXCEPT
{
    NN_SDK_REQUIRES( this->state == State_NotInitialized );
    NN_SDK_REQUIRES( info.GetPoolMemory() );

    NN_SDK_ASSERT( !this->pMemory );

    this->memorySize = info.GetPoolMemorySize();
    this->pMemory = info.GetPoolMemory();

    NN_GFX_CALL_GX_FUNCTION( GX2Invalidate(
        GX2_INVALIDATE_CPU, this->pMemory, this->memorySize ) );

    this->state = State_Initialized;
}

void MemoryPoolImpl< Target >::Finalize( DeviceImpl< Target >* ) NN_NOEXCEPT
{
    NN_SDK_REQUIRES( this->state == State_Initialized );

    this->pMemory = NULL;

    this->state = State_NotInitialized;
}

void* MemoryPoolImpl< Target >::Map() const NN_NOEXCEPT
{
    return this->pMemory;
}

void MemoryPoolImpl< Target >::Unmap() const NN_NOEXCEPT
{
}

void MemoryPoolImpl< Target >::FlushMappedRange( ptrdiff_t offset, size_t size ) const NN_NOEXCEPT
{
    ::DCFlushRange( nn::util::BytePtr( this->pMemory, offset ).Get(), size );
}

void MemoryPoolImpl< Target >::InvalidateMappedRange( ptrdiff_t offset, size_t size ) const NN_NOEXCEPT
{
    ::DCInvalidateRange( nn::util::BytePtr( this->pMemory, offset ).Get(), size );
}

}
}
}
