﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nvnTool/nvnTool_GlslcInterface.h>

extern bool glslcCompilePreSpecialized( GLSLCcompileObject * compileObject ) __attribute__( ( weak ) );
extern const GLSLCoutput * const * glslcCompileSpecialized( GLSLCcompileObject * compileObject, const GLSLCspecializationBatch * specEntries ) __attribute__( ( weak ) );
extern uint8_t glslcInitialize( GLSLCcompileObject * compileObject ) __attribute__( ( weak ) );
extern void glslcFinalize( GLSLCcompileObject * compileObject ) __attribute__( ( weak ) );
extern uint8_t glslcCompile( GLSLCcompileObject * compileObject ) __attribute__( ( weak ) );
extern GLSLCversion glslcGetVersion() __attribute__( ( weak ) );
extern void glslcSetAllocator( GLSLCallocateFunction allocate, GLSLCfreeFunction free, GLSLCreallocateFunction reallocate, void *userPtr ) __attribute__( ( weak ) );
extern GLSLCoptions glslcGetDefaultOptions() __attribute__( ( weak ) );

namespace nn {
namespace gfx {
namespace detail {

typedef bool( *GlslcCompilePreSpecializedType )( GLSLCcompileObject* compileObject );
typedef const GLSLCoutput* const* ( *GlslcCompileSpecializedType )(
    GLSLCcompileObject* compileObject, const GLSLCspecializationBatch* specEntries );
typedef uint8_t( *GlslcInitializeType )( GLSLCcompileObject* compileObject );
typedef void( *GlslcFinalizeType )( GLSLCcompileObject* compileObject );
typedef uint8_t( *GlslcCompileType )( GLSLCcompileObject* compileObject );
typedef GLSLCversion( *GlslcGetVersionType )();
typedef void( *GlslcSetAllocatorType )(
    GLSLCallocateFunction, GLSLCfreeFunction, GLSLCreallocateFunction, void* );
typedef GLSLCoptions( *GlslcGetDefaultOptionsType )();

GlslcCompilePreSpecializedType GetGlslcCompilePreSpecializedFunction()
{
    return glslcCompilePreSpecialized;
}

GlslcCompileSpecializedType GetGlslcCompileSpecializedFunction()
{
    return glslcCompileSpecialized;
}

GlslcInitializeType GetGlslcInitializeFunction()
{
    return glslcInitialize;
}

GlslcFinalizeType GetGlslcFinalizeFunction()
{
    return glslcFinalize;
}

GlslcCompileType GetGlslcCompileFunction()
{
    return glslcCompile;
}

GlslcGetVersionType GetGlslcGetVersionFunction()
{
    return glslcGetVersion;
}

GlslcSetAllocatorType GetGlslcSetAllocatorFunction()
{
    return glslcSetAllocator;
}

GlslcGetDefaultOptionsType GetGlslcGetDefaultOptionsFunction()
{
    return glslcGetDefaultOptions;
}

}
}
}
