﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Macro.h>

#if !defined( NN_BUILD_CONFIG_OS_HORIZON )
#error
#endif

#include <nn/nn_SdkAssert.h>
#include <nn/nn_Middleware.h>
#include <nn/nn_Version.h>

#include <nn/os/os_MutexApi.h>

#include <nn/gfx/gfx_DeviceInfo.h>

#include <nn/gfx/detail/gfx_Device-api.vk.1.h>

#include "gfx_CommonHelper.h"
#include "gfx_VkHelper.h"

#define NW_MIDDLEWARE_SYMBOL(buildOption) "NintendoSDK_gfxVkDebug-" NN_MACRO_STRINGIZE(NN_NX_ADDON_VERSION_MAJOR) "_" NN_MACRO_STRINGIZE(NN_NX_ADDON_VERSION_MINOR) "_" NN_MACRO_STRINGIZE(NN_NX_ADDON_VERSION_MICRO) "-" #buildOption

#if defined(NN_SDK_BUILD_DEBUG)
NN_DEFINE_MIDDLEWARE( g_MiddlewareInfo, "Nintendo", NW_MIDDLEWARE_SYMBOL( Debug ) );
#elif defined(NN_SDK_BUILD_DEVELOP)
NN_DEFINE_MIDDLEWARE( g_MiddlewareInfo, "Nintendo", NW_MIDDLEWARE_SYMBOL( Develop ) );
#elif defined(NN_SDK_BUILD_RELEASE)
NN_DEFINE_MIDDLEWARE( g_MiddlewareInfo, "Nintendo", NW_MIDDLEWARE_SYMBOL( Release ) );
#endif

namespace nn {
namespace gfx {
namespace detail {

typedef ApiVariationVk1 Target;

namespace {

//const char* LayerNames[] = {
//    "VK_LAYER_NN_vi_swapchain",
//};

const char* ExtensionNames[] = {
    VK_KHR_SURFACE_EXTENSION_NAME,
    VK_NN_VI_SURFACE_EXTENSION_NAME,
    VK_EXT_DEBUG_REPORT_EXTENSION_NAME,
};

}

DeviceImpl< Target >::DeviceImpl() NN_NOEXCEPT
{
    this->state = State_NotInitialized;
    this->pAllocationCallback = NULL;
}

DeviceImpl< Target >::~DeviceImpl() NN_NOEXCEPT
{
    NN_SDK_ASSERT( this->state == State_NotInitialized );
}

void DeviceImpl< Target >::Initialize( const InfoType& info ) NN_NOEXCEPT
{
    NN_USING_MIDDLEWARE( g_MiddlewareInfo );

    NN_SDK_REQUIRES( this->state == State_NotInitialized );
    NN_STATIC_ASSERT( sizeof( this->memoryPropertyFlags ) == sizeof( VkMemoryPropertyFlags ) * VK_MAX_MEMORY_TYPES );

    NN_GFX_CALL_NNOS_FUNCTION( nn::os::InitializeMutex(
        &this->mutex, true, nn::os::MutexLockLevelMax ) );
    NN_GFX_CALL_NNOS_FUNCTION( nn::os::InitializeMutex(
        &this->resouceMutex, true, nn::os::MutexLockLevelMax ) );

    Vk::EnumerateLayers();
    Vk::EnumerateInstanceExtensions();
    Vk::CreateInstance( this,
        0,
        nullptr,
        NN_ARRAY_SIZE( ExtensionNames ) - ( info.GetDebugMode() != DebugMode_Disable ? 0 : 1 ),
        ExtensionNames );

    this->debugMode = info.GetDebugMode() != DebugMode_Disable;

    Vk::InitializePhysicalDevice( this );
    Vk::EnumerateDeviceExtensions( this );

    const char* DeviceExtensions[] = {
        VK_KHR_SWAPCHAIN_EXTENSION_NAME,
        VK_KHR_SAMPLER_MIRROR_CLAMP_TO_EDGE_EXTENSION_NAME,
        VK_KHR_MAINTENANCE1_EXTENSION_NAME,
        VK_NV_GLSL_SHADER_EXTENSION_NAME,
        VK_NV_DEDICATED_ALLOCATION_EXTENSION_NAME,
        VK_KHR_MAINTENANCE2_EXTENSION_NAME,
    };

    Vk::CreateLogicalDevice( this,
        0,
        NULL,
        NN_ARRAY_SIZE( DeviceExtensions ), DeviceExtensions );

    if ( info.GetDebugMode() != DebugMode_Disable )
    {
        Vk::CreateDebugCallback( this );
    }

    Vk::CreatePipelineCache( this );
    Vk::CreateBufferMemoryHeap( this );
    Vk::CreateVkManagerList( this );

    this->state = State_Initialized;
}

void DeviceImpl< Target >::Finalize() NN_NOEXCEPT
{
    NN_SDK_REQUIRES( this->state == State_Initialized );

    if ( this->debugMode != DebugMode_Disable )
    {
        Vk::DestroyDebugCallback( this );
    }
    Vk::DestroyVkManagerList( this );
    Vk::DestroyBufferMemoryHeap( this );
    Vk::DestroyPipelineCache( this );
    Vk::DestroyLogicalDevice( this );
    Vk::DestroyInstance( this );

    NN_GFX_CALL_NNOS_FUNCTION( nn::os::FinalizeMutex( &this->mutex ) );
    NN_GFX_CALL_NNOS_FUNCTION( nn::os::FinalizeMutex( &this->resouceMutex ) );

    this->hDebugCallback = NULL;
    this->hDevice = NULL;
    this->hInstance = NULL;
    this->state = State_NotInitialized;
}

void DeviceImpl< Target >::Vk1SetAllocator( VkAllocator* pVkAllocator ) NN_NOEXCEPT
{
    this->pUserVkAllocator = pVkAllocator;
    Vk::UpdateAllocator( this );
}

}
}
}
