﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/ens/detail/ens_LibrarySettings.h>

namespace nn { namespace ens { namespace detail {

namespace
{
    // HTTP 通信の詳細情報出力オプション
    long g_HttpVerboseInformationOption = 0;
    // HTTP 通信の Keep-Alive タイムアウト
    nn::TimeSpan g_HttpKeepAliveTimeout = nn::TimeSpan::FromSeconds(60);

    // 通信性能のダンプが有効かどうか
    bool g_IsCommunicationPerformanceDumpEnabled = false;
    // 受信データのダンプが有効かどうか
    bool g_IsResponseDumpEnabled = false;
}

long LibrarySettings::GetHttpVerboseInformationOption() NN_NOEXCEPT
{
    return g_HttpVerboseInformationOption;
}

nn::TimeSpan LibrarySettings::GetHttpKeepAliveTimeout() NN_NOEXCEPT
{
    return g_HttpKeepAliveTimeout;
}

bool LibrarySettings::IsCommunicationPerformanceDumpEnabled() NN_NOEXCEPT
{
    return g_IsCommunicationPerformanceDumpEnabled;
}

bool LibrarySettings::IsResponseDumpEnabled() NN_NOEXCEPT
{
    return g_IsResponseDumpEnabled;
}

void LibrarySettings::SetHttpVerboseInformationOption(long option) NN_NOEXCEPT
{
    g_HttpVerboseInformationOption = option;
}

void LibrarySettings::SetHttpKeepAliveTimeout(nn::TimeSpan timeout) NN_NOEXCEPT
{
    g_HttpKeepAliveTimeout = timeout;
}

void LibrarySettings::SetCommunicationPerformanceDumpEnabled(bool isEnabled) NN_NOEXCEPT
{
    g_IsCommunicationPerformanceDumpEnabled = isEnabled;
}

void LibrarySettings::SetResponseDumpEnabled(bool isEnabled) NN_NOEXCEPT
{
    g_IsResponseDumpEnabled = isEnabled;
}

}}}
