﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/ens/detail/core/ens_Taskmanager.h>

namespace nn { namespace ens { namespace detail { namespace core {

TaskManager::TaskManager() NN_NOEXCEPT
{
}

TaskManager::~TaskManager() NN_NOEXCEPT
{
}

void TaskManager::PushHead(Task* pTask) NN_NOEXCEPT
{
    NN_SDK_REQUIRES_NOT_NULL(pTask);

    NN_UTIL_LOCK_GUARD(m_Mutex);

    m_TaskList.push_front(*pTask);

    for (auto it = m_EventList.begin(); it != m_EventList.end(); ++it)
    {
        it->Get().Signal();
    }
}

void TaskManager::PushTail(Task* pTask) NN_NOEXCEPT
{
    NN_SDK_REQUIRES_NOT_NULL(pTask);

    NN_UTIL_LOCK_GUARD(m_Mutex);

    m_TaskList.push_back(*pTask);

    for (auto it = m_EventList.begin(); it != m_EventList.end(); ++it)
    {
        it->Get().Signal();
    }
}

Task* TaskManager::Pop() NN_NOEXCEPT
{
    NN_UTIL_LOCK_GUARD(m_Mutex);

    if (m_TaskList.empty())
    {
        return nullptr;
    }

    Task* pTask = &m_TaskList.front();

    m_TaskList.pop_front();

    return pTask;
}

Task* TaskManager::Fetch(const TaskId& id) NN_NOEXCEPT
{
    NN_UTIL_LOCK_GUARD(m_Mutex);

    for (auto it = m_TaskList.begin(); it != m_TaskList.end(); ++it)
    {
        Task* pTask = &(*it);

        if (pTask->GetId() == id)
        {
            m_TaskList.erase(it);
            return pTask;
        }
    }

    return nullptr;
}

void TaskManager::RegisterEvent(detail::util::EventHolder* pEvent) NN_NOEXCEPT
{
    NN_SDK_REQUIRES_NOT_NULL(pEvent);

    NN_UTIL_LOCK_GUARD(m_Mutex);

    m_EventList.push_back(*pEvent);

    if (!m_TaskList.empty())
    {
        pEvent->Get().Signal();
    }
}

void TaskManager::UnregisterEvent(detail::util::EventHolder* pEvent) NN_NOEXCEPT
{
    NN_SDK_REQUIRES_NOT_NULL(pEvent);

    NN_UTIL_LOCK_GUARD(m_Mutex);

    for (auto it = m_EventList.begin(); it != m_EventList.end(); ++it)
    {
        if (&(*it) == pEvent)
        {
            m_EventList.erase(it);
            break;
        }
    }
}

}}}}
