﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/ens/detail/core/ens_AuthTokenCacheManager.h>

namespace nn { namespace ens { namespace detail { namespace core {

AuthTokenCacheManagerImpl::AuthTokenCacheManagerImpl(Item* pList, size_t num) NN_NOEXCEPT
    : m_pList(pList)
    , m_Num(num)
    , m_Count(0)
{
}

AuthTokenCacheManagerImpl::~AuthTokenCacheManagerImpl() NN_NOEXCEPT
{
}

void AuthTokenCacheManagerImpl::Clear() NN_NOEXCEPT
{
    m_Count = 0;
}

bool AuthTokenCacheManagerImpl::Get(AuthToken* pOutToken, const UserId& userId) const NN_NOEXCEPT
{
    NN_SDK_REQUIRES_NOT_NULL(pOutToken);
    NN_SDK_REQUIRES_NOT_EQUAL(userId, InvalidUserId);

    int index = Find(userId);

    if (index == -1)
    {
        return false;
    }

    std::memcpy(pOutToken, &m_pList[index].token, sizeof (m_pList[index].token));

    return true;
}

void AuthTokenCacheManagerImpl::Set(const UserId& userId, const AuthToken& token) NN_NOEXCEPT
{
    NN_SDK_REQUIRES_NOT_EQUAL(userId, InvalidUserId);

    int index = Find(userId);

    if (index == -1)
    {
        if (static_cast<size_t>(m_Count) == m_Num)
        {
            // 末尾（＝一番古い）アイテムを破棄する。
            m_Count--;
        }
        if (m_Count > 0)
        {
            std::memmove(&m_pList[1], &m_pList[0], sizeof (Item) * m_Count);
        }
        m_Count++;

        m_pList[0].userId = userId;
    }
    else if (index > 0)
    {
        std::memmove(&m_pList[1], &m_pList[0], sizeof (Item) * index);

        m_pList[0].userId = userId;
    }

    std::memcpy(&m_pList[0].token, &token, sizeof (token));
}

int AuthTokenCacheManagerImpl::Find(const UserId& userId) const NN_NOEXCEPT
{
    for (int i = 0; i < m_Count; i++)
    {
        if (m_pList[i].userId == userId)
        {
            return i;
        }
    }

    return -1;
}

}}}}
