﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nw/eft/eftvw2_CmdReceiver.h>

#include <nw/eft/eftcom_Message.h>
// #include <ProtocolEM4F.h>

namespace nw   {
namespace eftvw2 {


CmdReceiver* CmdReceiver::gCmdReceiver   = NULL;


//------------------------------------------------------------------------------
//　　　コマンド受信クラスを生成する
//------------------------------------------------------------------------------
CmdReceiver* CreateCmdReceiver( nw::eft2::Heap* heap )
{
    if ( CmdReceiver::gCmdReceiver )
    {
        return CmdReceiver::gCmdReceiver;
    }

    void* ptr = heap->Alloc( sizeof(CmdReceiver) );
    CmdReceiver* ret = new (ptr) CmdReceiver( heap );
    return ret;
}

//------------------------------------------------------------------------------
//　　　コマンド受信クラスを破棄する
//------------------------------------------------------------------------------
void DestroyCmdReceiver( nw::eft2::Heap* heap )
{
    EFT_NULL_ASSERT( heap );
    CmdReceiver::gCmdReceiver->~CmdReceiver();
    if ( CmdReceiver::gCmdReceiver ) heap->Free( CmdReceiver::gCmdReceiver );
}




//---------------------------------------------------------------------------
//! @brief        コンストラクタ
//---------------------------------------------------------------------------
CmdReceiver::CmdReceiver( nw::eft2::Heap* heap )
{
    mHeap               = heap;
    gCmdReceiver        = this;
    mLock               = false;
    mEffectIterator     = mTempEffectCmdQueue.End();

    mMutex.Initialize();
}


//---------------------------------------------------------------------------
//! @brief        デストラクタ
//---------------------------------------------------------------------------
CmdReceiver::~CmdReceiver()
{
    // 未実行のコマンドを削除
    while( GetEffectCommand() )
    {
        PopEffectCommand();
    }

    mMutex.Finalize();

    // 登録されたコールバックを削除
    //CBItemFixedArray::iterator ite = mCallbackListBefore.begin();
    //CBItemFixedArray::iterator end = mCallbackListBefore.end();
    //for( ; ite != end ; ++ite )
    //{
    //    mHeap->Free( (*ite) );
    //}
    //
    //ite = mCallbackListAfter.begin();
    //end = mCallbackListAfter.end();
    //for( ; ite != end ; ++ite )
    //{
    //    mHeap->Free( (*ite) );
    //}
}


//------------------------------------------------------------------------------
//　　　受信用プロシジャー
//------------------------------------------------------------------------------
void CmdReceiver::ReceiveProc( const void* pData, u32 size )
{
    gCmdReceiver->Lock();
    {
        // カテゴリを見て、ビューアコマンドとエフェクトコマンドを分岐させる
        const nw::eftcom::Message* pHeader = reinterpret_cast<const nw::eftcom::Message*>(pData);
        nw::eftcom::Message header = (*pHeader);

        u32 index               = 0;
        const u8* pPacketBuff   = (const u8*)pHeader;
        // const u8* pBody         = (const u8*)header + sizeof( nw::eftcom::Message );

        while ( header.bufferSize > 0 && index < size )
        {
            u32 szPacket = sizeof(nw::eftcom::Message) + header.bufferSize;
            //NW_LOG(" read size %d packet size %d\n", size, szPacket );

            // 受信したエフェクトコマンドを追加
    		gCmdReceiver->AddEffectCommand( CAFE_CMDID, pHeader, szPacket );

            // コールバックの呼び出し
            // gCmdReceiver->DoCallbackBeforeProc( header, pBody );

            // 次のパケットへ
            index += szPacket;
            pHeader = reinterpret_cast< const nw::eftcom::Message*>( &pPacketBuff[index] );
            header = (*pHeader);
        }
    }
    gCmdReceiver->Unlock();
}


////------------------------------------------------------------------------------
////　　　コールバックを追加(設定)する
////------------------------------------------------------------------------------
//void CmdReceiver::AddCallback( CBType cbType, void* pThis, ProtocolEM4F::MessageType msgType, CBFuncReceive func )
//{
//    CBItem* item = static_cast<CBItem*>( mHeap->Alloc( sizeof(CBItem) ) );
//    EFT_ASSERT( item );
//
//    item->Initialize(pThis, msgType, func);
//
//    if ( cbType == CBType_Before ){
//        mCallbackListBefore.push_back( item );
//    } else {
//        mCallbackListAfter.push_back( item );
//    }
//}
//
//
////------------------------------------------------------------------------------
////　　　タイプに該当するコールバック項目を取得します。（プロシージャ前にコール）
////------------------------------------------------------------------------------
//void CmdReceiver::DoCallbackBeforeProc( nw::eftcom::Messager* pHeader, const void* pBody )
//{
//    CBItemFixedArray::iterator ite = mCallbackListBefore.begin();
//    CBItemFixedArray::iterator end = mCallbackListBefore.end();
//    for( ; ite != end ; ++ite ){
//        if ( (*ite)->msgType == pHeader->type ){
//            // コールバック呼び出し
//            (*(*ite)->cbFunc)( (*ite)->pThis, pHeader, pBody );
//        }
//    }
//}
//
//
////------------------------------------------------------------------------------
////　　　タイプに該当するコールバック項目を取得します。（プロシージャ後にコール）
////------------------------------------------------------------------------------
//void CmdReceiver::DoCallbackAfterProc( nw::eftcom::Messager* pHeader, const void* pBody )
//{
//    CBItemFixedArray::iterator ite = mCallbackListAfter.begin();
//    CBItemFixedArray::iterator end = mCallbackListAfter.end();
//    for( ; ite != end ; ++ite ){
//        if ( (*ite)->msgType == pHeader->type ){
//            // コールバック呼び出し
//            (*(*ite)->cbFunc)( (*ite)->pThis, pHeader, pBody );
//        }
//    }
//}


} // namespace eftvw2
} // namespace nw
