﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/result/result_HandlingUtility.h>
#include <nn/capsrv/capsrv_Result.h>
#include "../visrv_ScreenShotContext.h"
#include "visrv_ActionTimeMeasure.h"

#include <nn/ovln/format/ovln_CapsrvMessage.h>

namespace nn{ namespace capsrv{ namespace server{ namespace screenshot{ namespace action{

    // OverlayDisp にサムネイルができたことを通知します
    // @param[in] context.OverlayNotifier
    // @param[in] context.AlbumFileId
    // @param[in] context.TakingScreenShotReason
    // @param[in] context.OverlayNotificationRequest
    static nn::Result NotifyThumbnailReadyToOverlayDisp(ScreenShotContext& context) NN_NOEXCEPT
    {
        NN_CAPSRV_SCREENSHOT_CONTEXT_SCOPE(context);
        NN_CAPSRV_SCREENSHOT_CONTEXT_REQUIRES_IN(context, OverlayNotifier);
        NN_CAPSRV_SCREENSHOT_CONTEXT_REQUIRES_IN(context, OverlayNotificationRequest);
        NN_CAPSRV_SCREENSHOT_CONTEXT_REQUIRES_IN(context, AlbumFileId);
        NN_CAPSRV_SCREENSHOT_CONTEXT_REQUIRES_IN(context, TakingScreenShotReason);

        NN_CAPSRV_SCREENSHOT_ACTION_TIMEMEASURE("notify tmb");

        NN_CAPSRV_SCREENSHOT_CONTEXT_GET(request, context, OverlayNotificationRequest);
        if((request & OverlayNotificationRequest_OnSuccess) == 0)
        {
            NN_RESULT_SUCCESS;
        }

        NN_CAPSRV_SCREENSHOT_CONTEXT_GET(fileId, context, AlbumFileId);
        AlbumEntry entry = {};
        entry.fileId = fileId;
        entry.size   = -1;

        NN_CAPSRV_SCREENSHOT_CONTEXT_GET(reason, context, TakingScreenShotReason);
        nn::ovln::format::ScreenShotCapturedData data = {};
        data.reason = reason;
        data.result = nn::ovln::format::ScreenShotResult::ThumbnailIsReady;
        data.flags.Set(nn::ovln::format::ScreenShotResultFlag::IsThumbnailAvailable::Index, true);
        std::memcpy(&data._entry, &entry, sizeof(AlbumEntry));

        NN_CAPSRV_SCREENSHOT_CONTEXT_GET(pOverlayNotifier, context, OverlayNotifier);
        NN_RESULT_DO(pOverlayNotifier->SendToOverlay(data));
        NN_RESULT_SUCCESS;
    }

}}}}}
