﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/result/result_HandlingUtility.h>
#include <nn/capsrv/capsrv_Result.h>
#include "../visrv_ScreenShotContext.h"
#include "visrv_ActionTimeMeasure.h"

#include <nn/capsrv/capsrv_ViewerThumbnailFormat.h>
#include "../../capsrvServer_Config.h"
#include "../visrv_ScreenShotUtility.h"

namespace nn{ namespace capsrv{ namespace server{ namespace screenshot{ namespace action{

    // PhotoViewer 用のサムネイルを JPEG エンコードする
    // @param[in]  context.RawViewerThumbnailMemory
    // @param[out] context.EncodedViewerThumbnailMemory
    // @param[out] context.EncodedViewerThumbnailSize
    // @param      context.EncoderWorkMemory
    static nn::Result EncodeViewerThumbnailJpeg(ScreenShotContext& context) NN_NOEXCEPT
    {
        NN_CAPSRV_SCREENSHOT_CONTEXT_SCOPE(context);
        NN_CAPSRV_SCREENSHOT_CONTEXT_REQUIRES_MEMORY(context, RawViewerThumbnailMemory, ViewerThumbnailImageDataSize_Raw);
        NN_CAPSRV_SCREENSHOT_CONTEXT_REQUIRES_MEMORY(context, EncodedViewerThumbnailMemory, ViewerThumbnailImageDataSize_EncodedLimit);
        NN_CAPSRV_SCREENSHOT_CONTEXT_REQUIRES_MEMORY(context, EncoderWorkMemory, SoftwareJpegEncoderWorkMemorySize);
        NN_CAPSRV_SCREENSHOT_CONTEXT_REQUIRES_OUT(context, EncodedViewerThumbnailSize);

        NN_CAPSRV_SCREENSHOT_ACTION_TIMEMEASURE("encode pv ");

        NN_CAPSRV_SCREENSHOT_CONTEXT_GET_MEMORY(pRawData, rawDataSize, context, RawViewerThumbnailMemory);

        NN_CAPSRV_SCREENSHOT_CONTEXT_GET_MEMORY(pBuffer, bufferSize, context, EncodedViewerThumbnailMemory);
        std::memset(pBuffer, 0, bufferSize);

        NN_CAPSRV_SCREENSHOT_CONTEXT_GET_MEMORY(pWork, workSize, context, EncoderWorkMemory);
        std::memset(pWork, 0, workSize);

        size_t encodedSize = 0;

        jpeg::SoftwareJpegEncoderBufferInputInfoRgba8 inputInfo = {};
        inputInfo.width      = ViewerThumbnailImageSize_Width;
        inputInfo.height     = ViewerThumbnailImageSize_Height;
        inputInfo.pImageData = pRawData;
        inputInfo.imageSize  = rawDataSize;

        jpeg::SoftwareJpegEncoderBufferOutputInfo outputInfo = {};
        outputInfo.pOutSize   = &encodedSize;
        outputInfo.pBuffer    = pBuffer;
        outputInfo.bufferSize = (bufferSize < ViewerThumbnailImageDataSize_EncodedLimit) ? bufferSize : ViewerThumbnailImageDataSize_EncodedLimit;

        NN_RESULT_TRY(ScreenShotUtility::EncodeRgba8BufferToBuffer(
            outputInfo,
            inputInfo,
            nullptr,
            pWork,
            workSize
        ))
            NN_RESULT_CATCH_ALL
            {
                // エンコードできなかった場合はサイズ 0 を設定
                // 結果は成功扱い
                encodedSize = 0;
            }
        NN_RESULT_END_TRY;

        NN_ABORT_UNLESS_GREATER_EQUAL(bufferSize, encodedSize);

        NN_CAPSRV_SCREENSHOT_CONTEXT_SET(context, EncodedViewerThumbnailSize, encodedSize);
        NN_RESULT_SUCCESS;
    }
}}}}}
